﻿Namespace Z80A

    Module msxZ80A

        Public Z80A_REG_PC As Integer '0~65535
        Public Z80A_REG_SP As Integer

        Public Z80A_REG_IX As Integer
        Public Z80A_REG_IY As Integer

        Public Z80A_REG_A As Integer '0~255
        Public Z80A_REG_F As Integer
        Public Z80A_REG_B As Integer
        Public Z80A_REG_C As Integer
        Public Z80A_REG_D As Integer
        Public Z80A_REG_E As Integer
        Public Z80A_REG_H As Integer
        Public Z80A_REG_L As Integer

        Public Z80A_REG_A2 As Integer
        Public Z80A_REG_F2 As Integer
        Public Z80A_REG_B2 As Integer
        Public Z80A_REG_C2 As Integer
        Public Z80A_REG_D2 As Integer
        Public Z80A_REG_E2 As Integer
        Public Z80A_REG_H2 As Integer
        Public Z80A_REG_L2 As Integer

        Public Z80A_REG_I As Integer
        Public Z80A_REG_R As Integer

        Public Z80A_REG_IFF1 As Integer
        Public Z80A_REG_IFF2 As Integer

        Public Const C_Flag As Integer = &H100
        Public Const S_Flag16 As Integer = &H8000
        Public Const S_Flag As Integer = &H80
        Public Const H_Flag16 As Integer = &H1000
        Public Const H_Flag As Integer = &H10

        Public Sub MSX_INIT_Z80A()

            Z80A_REG_PC = 0
            Z80A_REG_SP = 0
            Z80A_REG_IX = 0
            Z80A_REG_IY = 0

            Z80A_REG_A = 0
            Z80A_REG_F = 0
            Z80A_REG_B = 0
            Z80A_REG_C = 0
            Z80A_REG_D = 0
            Z80A_REG_E = 0
            Z80A_REG_H = 0
            Z80A_REG_L = 0

            Z80A_REG_A2 = 0
            Z80A_REG_F2 = 0
            Z80A_REG_B2 = 0
            Z80A_REG_C2 = 0
            Z80A_REG_D2 = 0
            Z80A_REG_E2 = 0
            Z80A_REG_H2 = 0
            Z80A_REG_L2 = 0

            Z80A_REG_I = 0
            Z80A_REG_R = 0
            Z80A_REG_IFF1 = 0
            Z80A_REG_IFF2 = 0

        End Sub

        Public Sub EXEC_Z80A_ADD_PC(ByVal iSz As Integer, ByVal iSz0 As Integer)

            Z80A_REG_PC = ((Z80A_REG_PC + iSz) And &HFFFF)
            If (iSz = 0) Then iSz = iSz0
            MSX.Gi_Z80A_ClockSize = MSX.Gi_Z80A_CLOCK + iSz

        End Sub

        Public Function GET_Z80A_REG_AF() As Integer

            GET_Z80A_REG_AF = ((Z80A_REG_A << 8) Or Z80A_REG_F)

        End Function

        Public Function GET_Z80A_REG_BC() As Integer

            GET_Z80A_REG_BC = ((Z80A_REG_B << 8) Or Z80A_REG_C)

        End Function

        Public Function GET_Z80A_REG_DE() As Integer

            GET_Z80A_REG_DE = ((Z80A_REG_D << 8) Or Z80A_REG_E)

        End Function

        Public Function GET_Z80A_REG_HL() As Integer

            GET_Z80A_REG_HL = ((Z80A_REG_H << 8) Or Z80A_REG_L)

        End Function

        Public Function GET_Z80A_REG_AF2() As Integer

            GET_Z80A_REG_AF2 = ((Z80A_REG_A2 << 8) Or Z80A_REG_F2)

        End Function

        Public Function GET_Z80A_REG_BC2() As Integer

            GET_Z80A_REG_BC2 = ((Z80A_REG_B2 << 8) Or Z80A_REG_C2)

        End Function

        Public Function GET_Z80A_REG_DE2() As Integer

            GET_Z80A_REG_DE2 = ((Z80A_REG_D2 << 8) Or Z80A_REG_E2)

        End Function

        Public Function GET_Z80A_REG_HL2() As Integer

            GET_Z80A_REG_HL2 = ((Z80A_REG_H2 << 8) Or Z80A_REG_L2)

        End Function

        Public Sub PUT_Z80A_REG_AF(ByVal oVal As Integer)

            Z80A_REG_A = (oVal >> 8)
            Z80A_REG_F = (oVal And &HFF)

        End Sub

        Public Sub PUT_Z80A_REG_BC(ByVal oVal As Integer)

            Z80A_REG_B = (oVal >> 8)
            Z80A_REG_C = (oVal And &HFF)

        End Sub

        Public Sub PUT_Z80A_REG_DE(ByVal oVal As Integer)

            Z80A_REG_D = (oVal >> 8)
            Z80A_REG_E = (oVal And &HFF)

        End Sub

        Public Sub PUT_Z80A_REG_HL(ByVal oVal As Integer)

            Z80A_REG_H = (oVal >> 8)
            Z80A_REG_L = (oVal And &HFF)

        End Sub

        Public Sub PUT_Z80A_REG_AF2(ByVal oVal As Integer)

            Z80A_REG_A2 = (oVal >> 8)
            Z80A_REG_F2 = (oVal And &HFF)

        End Sub

        Public Sub PUT_Z80A_REG_BC2(ByVal oVal As Integer)

            Z80A_REG_B2 = (oVal >> 8)
            Z80A_REG_C2 = (oVal And &HFF)

        End Sub

        Public Sub PUT_Z80A_REG_DE2(ByVal oVal As Integer)

            Z80A_REG_D2 = (oVal >> 8)
            Z80A_REG_E2 = (oVal And &HFF)

        End Sub

        Public Sub PUT_Z80A_REG_HL2(ByVal oVal As Integer)

            Z80A_REG_H2 = (oVal >> 8)
            Z80A_REG_L2 = (oVal And &HFF)

        End Sub

        Public Function GET_Z80A_REG_IXH() As Integer

            GET_Z80A_REG_IXH = (Z80A_REG_IX >> 8)

        End Function

        Public Function GET_Z80A_REG_IXL() As Integer

            GET_Z80A_REG_IXL = (Z80A_REG_IX And &HFF)

        End Function

        Public Function GET_Z80A_REG_IYH() As Integer

            GET_Z80A_REG_IYH = (Z80A_REG_IY >> 8)

        End Function

        Public Function GET_Z80A_REG_IYL() As Integer

            GET_Z80A_REG_IYL = (Z80A_REG_IY And &HFF)

        End Function

        Public Sub PUT_Z80A_REG_IXH(ByVal iVal As Integer)

            Z80A_REG_IX = ((Z80A_REG_IX And &HFF) Or (iVal << 8))

        End Sub

        Public Sub PUT_Z80A_REG_IXL(ByVal iVal As Integer)

            Z80A_REG_IX = ((Z80A_REG_IX And &HFF00) Or (iVal))

        End Sub

        Public Sub PUT_Z80A_REG_IYH(ByVal iVal As Integer)

            Z80A_REG_IY = ((Z80A_REG_IY And &HFF) Or (iVal << 8))

        End Sub

        Public Sub PUT_Z80A_REG_IYL(ByVal iVal As Integer)

            Z80A_REG_IY = ((Z80A_REG_IY And &HFF00) Or (iVal))

        End Sub

        Public Function GET_Z80A_FLAG_S() As Integer

            GET_Z80A_FLAG_S = IIf((Z80A_REG_F And 128) = 0, 0, 1) '1000 0000

        End Function

        Public Function GET_Z80A_FLAG_Z() As Integer

            GET_Z80A_FLAG_Z = IIf((Z80A_REG_F And 64) = 0, 0, 1) '0100 0000

        End Function

        Public Function GET_Z80A_FLAG_Y() As Integer

            GET_Z80A_FLAG_Y = IIf((Z80A_REG_F And 32) = 0, 0, 1) '0010 0000

        End Function

        Public Function GET_Z80A_FLAG_H() As Integer

            GET_Z80A_FLAG_H = IIf((Z80A_REG_F And 16) = 0, 0, 1) '0001 0000

        End Function

        Public Function GET_Z80A_FLAG_X() As Integer

            GET_Z80A_FLAG_X = IIf((Z80A_REG_F And 8) = 0, 0, 1) '0000 1000

        End Function

        Public Function GET_Z80A_FLAG_PV() As Integer

            GET_Z80A_FLAG_PV = IIf((Z80A_REG_F And 4) = 0, 0, 1) '0000 0100

        End Function

        Public Function GET_Z80A_FLAG_N() As Integer

            GET_Z80A_FLAG_N = IIf((Z80A_REG_F And 2) = 0, 0, 1) '0000 0010

        End Function

        Public Function GET_Z80A_FLAG_C() As Integer

            GET_Z80A_FLAG_C = IIf((Z80A_REG_F And 1) = 0, 0, 1) '0000 0001

        End Function

        Public Sub PUT_Z80A_FLAG_S(ByVal iVal As Integer)

            If (iVal = 0) Then
                Z80A_REG_F = (Z80A_REG_F And &H7F) '0111 1111
            Else
                Z80A_REG_F = (Z80A_REG_F Or 128) '1000 0000
            End If

        End Sub

        Public Sub PUT_Z80A_FLAG_Z(ByVal iVal As Integer)

            If (iVal = 0) Then
                Z80A_REG_F = (Z80A_REG_F And &HBF) '1011 1111
            Else
                Z80A_REG_F = (Z80A_REG_F Or 64) '0100 0000
            End If

        End Sub

        Public Sub PUT_Z80A_FLAG_Y(ByVal iVal As Integer)

            If (iVal = 0) Then
                Z80A_REG_F = (Z80A_REG_F And &HDF) '1101 1111
            Else
                Z80A_REG_F = (Z80A_REG_F Or 32) '0010 0000
            End If

        End Sub

        Public Sub PUT_Z80A_FLAG_H(ByVal iVal As Integer)

            If (iVal = 0) Then
                Z80A_REG_F = (Z80A_REG_F And &HEF) '1110 1111
            Else
                Z80A_REG_F = (Z80A_REG_F Or 16) '0001 0000
            End If

        End Sub

        Public Sub PUT_Z80A_FLAG_X(ByVal iVal As Integer)

            If (iVal = 0) Then
                Z80A_REG_F = (Z80A_REG_F And &HF7) '1111 0111
            Else
                Z80A_REG_F = (Z80A_REG_F Or 8) '0000 1000
            End If

        End Sub

        Public Sub PUT_Z80A_FLAG_PV(ByVal iVal As Integer)

            If (iVal = 0) Then
                Z80A_REG_F = (Z80A_REG_F And &HFB) '1111 1011
            Else
                Z80A_REG_F = (Z80A_REG_F Or 4) '0000 0100
            End If

        End Sub

        Public Sub PUT_Z80A_FLAG_N(ByVal iVal As Integer)

            If (iVal = 0) Then
                Z80A_REG_F = (Z80A_REG_F And &HFD) '1111 1101
            Else
                Z80A_REG_F = (Z80A_REG_F Or 2) '0000 0010
            End If

        End Sub

        Public Sub PUT_Z80A_FLAG_C(ByVal iVal As Integer)

            If (iVal = 0) Then
                Z80A_REG_F = (Z80A_REG_F And &HFE) '1111 1110
            Else
                Z80A_REG_F = (Z80A_REG_F Or 1) '0000 0001
            End If

        End Sub

        Public Function giGetIdx8(ByVal iVal As Integer) As Integer

            If (iVal > 127) Then
                giGetIdx8 = (iVal - 256)
            Else
                giGetIdx8 = (iVal)
            End If

        End Function

        Public Function giGet16Sign(ByVal oVal As Integer) As Integer

            'Sign 16 Bit (1:음수,0:양수)
            If (oVal > 32767) Then
                giGet16Sign = 1
            Else
                giGet16Sign = 0
            End If

        End Function

        Public Function giGet8Sign(ByVal iVal As Integer) As Integer

            'Sign 8 Bit (1:음수,0:양수)
            If (iVal > 127) Then
                giGet8Sign = 1
            Else
                giGet8Sign = 0
            End If

        End Function

        Public Function giGet16Zero(ByVal oVal As Integer) As Integer

            'Zero 16 Bit (1:Zero1,0:Other)
            If (oVal = 0) Then
                giGet16Zero = 1
            Else
                giGet16Zero = 0
            End If

        End Function

        Public Function giGet8Zero(ByVal iVal As Integer) As Integer

            'Zero 8 Bit (1:Zero1,0:Other)
            If (iVal = 0) Then
                giGet8Zero = 1
            Else
                giGet8Zero = 0
            End If

        End Function

        Public Function goGetLngToLng(ByVal oVal As Integer) As Integer

            Dim R As Integer

            R = oVal
            If (R < 0) Then R = R + 65536
            If (R > 65535) Then R = R And &HFFFF '-65536;

            goGetLngToLng = R

        End Function

        Public Function giGetIntToInt(ByVal iVal As Integer) As Integer

            Dim R As Integer

            R = iVal
            If (R < 0) Then R = R + 256
            If (R > 255) Then R = R And &HFF '-256;

            giGetIntToInt = R

        End Function

        Public Function goGetIntHLToLng(ByVal iValH As Integer, ByVal iValL As Integer) As Integer

            goGetIntHLToLng = ((iValH << 8) Or iValL)

        End Function

        Public Sub gtMoveLngToIntHL(ByVal oVal As Integer, ByRef iValH As Integer, ByRef iValL As Integer)

            iValH = (oVal >> 8)
            iValL = (oVal And &HFF)

        End Sub

        Public Function giGetLngToIntH(ByVal Reg16 As Integer) As Integer

            giGetLngToIntH = (Reg16 >> 8)

        End Function

        Public Function giGetLngToIntL(ByVal Reg16 As Integer) As Integer

            giGetLngToIntL = (Reg16 And &HFF)

        End Function

        Public Sub gt_INC_16TO16(ByVal oVal As Integer, ByRef Reg16 As Integer)

            'nn=nn+1
            Reg16 = goGetLngToLng(oVal + 1) 'INC

        End Sub

        Public Sub gt_DEC_16TO16(ByVal oVal As Integer, ByRef Reg16 As Integer)

            'nn=nn-1
            Reg16 = goGetLngToLng(oVal - 1) 'DEC

        End Sub

        Public Sub gt_INC_16TO8(ByVal oVal As Integer, ByRef RegH As Integer, ByRef RegL As Integer)

            Dim Reg16 As Integer
            'nn=nn+1
            Reg16 = goGetLngToLng(oVal + 1) 'INC
            RegH = giGetLngToIntH(Reg16)
            RegL = giGetLngToIntL(Reg16)

        End Sub

        Public Sub gt_DEC_16TO8(ByVal oVal As Integer, ByRef RegH As Integer, ByRef RegL As Integer)

            Dim Reg16 As Integer
            'nn=nn-1
            Reg16 = goGetLngToLng(oVal - 1) 'DEC
            RegH = giGetLngToIntH(Reg16)
            RegL = giGetLngToIntL(Reg16)

        End Sub

        Public Sub gt_INC_8TO8(ByVal iVal As Integer, ByRef Reg8 As Integer)

            Dim iResult As Integer
            'i=i+1
            'S=Sign(i), Z=Zero(i), H=Hcry(i), Before P=7Fh, N=0
            Call PUT_Z80A_FLAG_N(0) 'Not뺄셈
            iResult = (iVal + 1) 'INC
            Reg8 = (iResult And &HFF)
            Call PUT_Z80A_FLAG_H(IIf((iVal And &HF) = 15, 1, 0)) '하프캐리
            Call PUT_Z80A_FLAG_PV(IIf(iVal = &H7F, 1, 0)) '오버플로
            Call PUT_Z80A_FLAG_S(giGet8Sign(Reg8)) 'Sign
            Call PUT_Z80A_FLAG_Z(giGet8Zero(Reg8)) 'Zero

        End Sub

        Public Sub gt_DEC_8TO8(ByVal iVal As Integer, ByRef Reg8 As Integer)

            Dim iResult As Integer
            'i=i-1
            'S=Sign(i), Z=Zero(i), H=Hbrw(i), Before P=80h, N=1
            Call PUT_Z80A_FLAG_N(1) '뺄셈
            iResult = (iVal - 1) 'DEC
            Reg8 = giGetIntToInt(iResult)
            Call PUT_Z80A_FLAG_H(IIf((iVal And &HF) = 0, 1, 0)) '하프캐리
            Call PUT_Z80A_FLAG_PV(IIf(iVal = &H80, 1, 0)) '오버플로
            Call PUT_Z80A_FLAG_S(giGet8Sign(Reg8)) 'Sign
            Call PUT_Z80A_FLAG_Z(giGet8Zero(Reg8)) 'Zero

        End Sub

        Public Sub gt_ADD_16TO16(ByVal oVal1 As Integer, ByVal oVal2 As Integer, ByRef Reg16 As Integer, ByVal iCv As Integer)

            Call ft_ADD_16TO16(oVal1, oVal2, Reg16, iCv)

        End Sub

        Public Sub gt_SUB_16TO16(ByVal oVal1 As Integer, ByVal oVal2 As Integer, ByRef Reg16 As Integer, ByVal iCv As Integer)

            Call ft_SUB_16TO16(oVal1, oVal2, Reg16, iCv)

        End Sub

        Public Sub gt_ADD_16TO8(ByVal oVal1 As Integer, ByVal oVal2 As Integer, ByRef RegH As Integer, ByRef RegL As Integer, ByVal iCv As Integer)

            Dim Reg16 As Integer = 0

            Call ft_ADD_16TO16(oVal1, oVal2, Reg16, iCv)
            RegH = giGetLngToIntH(Reg16)
            RegL = giGetLngToIntL(Reg16)

        End Sub

        Public Sub gt_SUB_16TO8(ByVal oVal1 As Integer, ByVal oVal2 As Integer, ByRef RegH As Integer, ByRef RegL As Integer, ByVal iCv As Integer)

            Dim Reg16 As Integer = 0

            Call ft_SUB_16TO16(oVal1, oVal2, Reg16, iCv)
            RegH = giGetLngToIntH(Reg16)
            RegL = giGetLngToIntL(Reg16)

        End Sub

        Public Sub ft_ADD_16TO16(ByVal oVal1 As Integer, ByVal oVal2 As Integer, ByRef Reg16 As Integer, ByVal iCv As Integer)

            Dim oResult As Integer, iCarry As Integer
            'nn=nn+rr
            'H=Hcry(nn), N=0, C=Carry(nn) : ADD
            'S=Sign(nn), Z=Zero(nn), P=Oflow(nn) : ADC
            Call PUT_Z80A_FLAG_N(0) 'Not뺄셈
            iCarry = IIf(iCv = 1, GET_Z80A_FLAG_C(), 0) 'ADC
            oResult = (oVal1 + oVal2 + iCarry) 'ADD
            Reg16 = (oResult And &HFFFF)
            Call PUT_Z80A_FLAG_C(IIf(Reg16 <> oResult, 1, 0)) '캐리
            Call PUT_Z80A_FLAG_H(IIf(((oVal1 And &HFFF) + ((oVal2 + iCarry) And &HFFF)) > &HFFF, 1, 0)) '하프캐리
            If (iCv = 1) Then
                Call PUT_Z80A_FLAG_PV(IIf(((oVal1 Xor oResult) And ((oVal2 + iCarry) Xor oResult) And S_Flag16) <> 0, 1, 0)) '오버플로
                Call PUT_Z80A_FLAG_S(giGet16Sign(Reg16))
                Call PUT_Z80A_FLAG_Z(giGet16Zero(Reg16))
            End If

        End Sub

        Public Sub ft_SUB_16TO16(ByVal oVal1 As Integer, ByVal oVal2 As Integer, ByRef Reg16 As Integer, ByVal iCv As Integer)

            Dim oResult As Integer, iCarry As Integer
            'nn=nn-rr
            'H=Hbrw(nn), N=1, C=Borrow(nn) : SUB
            'S=Sign(nn), Z=Zero(nn), P=Oflow(nn) : SBC
            Call PUT_Z80A_FLAG_N(1) '뺄셈
            iCarry = IIf(iCv = 1, GET_Z80A_FLAG_C(), 0) 'SBC
            oResult = (oVal1 - oVal2 - iCarry) 'SUB
            Reg16 = goGetLngToLng(oResult)
            Call PUT_Z80A_FLAG_C(IIf(Reg16 <> oResult, 1, 0)) '캐리
            Call PUT_Z80A_FLAG_H(IIf((oVal1 And &HFFF) < ((oVal2 + iCarry) And &HFFF), 1, 0)) '하프캐리
            If (iCv = 1) Then
                Call PUT_Z80A_FLAG_PV(IIf(((oVal1 Xor (oVal2 + iCarry)) And (oVal1 Xor oResult) And S_Flag16) <> 0, 1, 0)) '오버플로
                Call PUT_Z80A_FLAG_S(giGet16Sign(Reg16))
                Call PUT_Z80A_FLAG_Z(giGet16Zero(Reg16))
            End If

        End Sub

        Public Sub gt_ADD_8TO8(ByVal iVal1 As Integer, ByVal iVal2 As Integer, ByRef Reg8 As Integer, ByVal iCv As Integer)

            Dim iResult As Integer, iCarry As Integer
            'i=i+r
            'S=Sign(i), Z=Zero(i), H=Hcry(i), P=Oflow(i), N=0, C=Carry(i)
            Call PUT_Z80A_FLAG_N(0) 'Not뺄셈
            iCarry = IIf(iCv = 1, GET_Z80A_FLAG_C(), 0) 'ADC
            iResult = (iVal1 + iVal2 + iCarry) 'ADD
            Reg8 = (iResult And &HFF)
            Call PUT_Z80A_FLAG_C(IIf(Reg8 <> iResult, 1, 0)) '캐리
            Call PUT_Z80A_FLAG_H(IIf(((iVal1 And &HF) + ((iVal2 + iCarry) And &HF)) > &HF, 1, 0)) '하프캐리
            Call PUT_Z80A_FLAG_PV(IIf(((iVal1 Xor iResult) And ((iVal2 + iCarry) Xor iResult) And S_Flag) <> 0, 1, 0)) '오버플로
            Call PUT_Z80A_FLAG_S(giGet8Sign(Reg8)) 'Sign
            Call PUT_Z80A_FLAG_Z(giGet8Zero(Reg8)) 'Zero

        End Sub

        Public Sub gt_SUB_8TO8(ByVal iVal1 As Integer, ByVal iVal2 As Integer, ByRef Reg8 As Integer, ByVal iCv As Integer)

            Dim iResult As Integer, iCarry As Integer
            'i=i-r
            'S=Sign(i), Z=Zero(i), H=Hbrw(i), P=Oflow(i), N=0, C=Borrow(i)
            Call PUT_Z80A_FLAG_N(1) '뺄셈
            iCarry = IIf(iCv = 1, GET_Z80A_FLAG_C(), 0) 'SBC
            iResult = (iVal1 - iVal2 - iCarry) 'SUB
            Reg8 = giGetIntToInt(iResult)
            Call PUT_Z80A_FLAG_C(IIf(Reg8 <> iResult, 1, 0)) '캐리
            Call PUT_Z80A_FLAG_H(IIf((iVal1 And &HF) < ((iVal2 + iCarry) And &HF), 1, 0)) '하프캐리
            Call PUT_Z80A_FLAG_PV(IIf(((iVal1 Xor (iVal2 + iCarry)) And (iVal1 Xor iResult) And S_Flag) <> 0, 1, 0)) '오버플로
            Call PUT_Z80A_FLAG_S(giGet8Sign(Reg8)) 'Sign
            Call PUT_Z80A_FLAG_Z(giGet8Zero(Reg8)) 'Zero

        End Sub

        Public Sub gt_CP(ByVal iVal2 As Integer)

            Dim iResult As Integer, Reg8 As Integer
            'CP=i-r
            'S=Sign(CP), Z=Zero(CP), H=Hbrw(CP), P=Oflow(CP), N=1, C=Borrow(CP)
            Call PUT_Z80A_FLAG_N(1) '뺄셈
            iResult = (Z80A_REG_A - iVal2) 'SUB
            Reg8 = giGetIntToInt(iResult)
            Call PUT_Z80A_FLAG_C(IIf(Reg8 <> iResult, 1, 0)) '캐리
            Call PUT_Z80A_FLAG_H(IIf((Z80A_REG_A And &HF) < (iVal2 And &HF), 1, 0)) '하프캐리
            Call PUT_Z80A_FLAG_PV(0) '오버플로
            Call PUT_Z80A_FLAG_S(giGet8Sign(Reg8)) 'Sign
            Call PUT_Z80A_FLAG_Z(giGet8Zero(Reg8)) 'Zero

        End Sub

        Public Sub gt_AND_8TO8(ByVal iVal1 As Integer, ByVal iVal2 As Integer, ByRef Reg8 As Integer)

            'i=i And r
            'S=Sign(i), Z=Zero(i), H=1, P=Peven(i), N=0, C=0
            Call PUT_Z80A_FLAG_N(0) 'Not뺄셈
            Reg8 = (iVal1 And iVal2) 'AND
            Call PUT_Z80A_FLAG_C(0) 'Not캐리
            Call PUT_Z80A_FLAG_H(1) '하프캐리
            Call PUT_Z80A_FLAG_PV(TBL.Gi_P_Table(Reg8)) '1:짝수,0:홀수
            Call PUT_Z80A_FLAG_S(giGet8Sign(Reg8)) 'Sign
            Call PUT_Z80A_FLAG_Z(giGet8Zero(Reg8)) 'Zero

        End Sub

        Public Sub gt_XOR_8TO8(ByVal iVal1 As Integer, ByVal iVal2 As Integer, ByRef Reg8 As Integer)

            'i=i Xor r
            'S=Sign(i), Z=Zero(i), H=0, P=Peven(i), N=0, C=0
            Call PUT_Z80A_FLAG_N(0) 'Not뺄셈
            Reg8 = (iVal1 Xor iVal2) 'XOR
            Call PUT_Z80A_FLAG_C(0) 'Not캐리
            Call PUT_Z80A_FLAG_H(0) 'Not하프캐리
            Call PUT_Z80A_FLAG_PV(TBL.Gi_P_Table(Reg8)) '1:짝수,0:홀수
            Call PUT_Z80A_FLAG_S(giGet8Sign(Reg8)) 'Sign
            Call PUT_Z80A_FLAG_Z(giGet8Zero(Reg8)) 'Zero

        End Sub

        Public Sub gt_OR_8TO8(ByVal iVal1 As Integer, ByVal iVal2 As Integer, ByRef Reg8 As Integer)

            'i=i Or r
            'S=Sign(i), Z=Zero(i), H=0, P=Peven(i), N=0, C=0
            Call PUT_Z80A_FLAG_N(0) 'Not뺄셈
            Reg8 = (iVal1 Or iVal2) 'OR
            Call PUT_Z80A_FLAG_C(0) 'Not캐리
            Call PUT_Z80A_FLAG_H(0) 'Not하프캐리
            Call PUT_Z80A_FLAG_PV(TBL.Gi_P_Table(Reg8)) '1:짝수,0:홀수
            Call PUT_Z80A_FLAG_S(giGet8Sign(Reg8)) 'Sign
            Call PUT_Z80A_FLAG_Z(giGet8Zero(Reg8)) 'Zero

        End Sub

        Public Sub gt_BIT(ByVal iBit As Integer, ByVal Reg8 As Integer)

            'Z=bit=0, H=1, N=0
            Call PUT_Z80A_FLAG_N(0) '뺄셈
            Call PUT_Z80A_FLAG_Z(IIf((Reg8 And TBL.Gi_B_Table(iBit)) = 0, 1, 0)) '1:Zero
            Call PUT_Z80A_FLAG_H(1) '하프캐리

        End Sub

        Public Sub gt_SET(ByVal iBit As Integer, ByRef Reg8 As Integer)

            'bit<=1
            Reg8 = (Reg8 Or TBL.Gi_B_Table(iBit)) '1

        End Sub

        Public Sub gt_RES(ByVal iBit As Integer, ByRef Reg8 As Integer)

            'bit<=0
            Reg8 = (Reg8 And TBL.Gi_NB_Table(iBit)) '0

        End Sub

        Public Sub gt_SCF()

            'C=1, H=0, N=0
            Call PUT_Z80A_FLAG_N(0) 'NOT제로
            Call PUT_Z80A_FLAG_H(0) '하프캐리
            Call PUT_Z80A_FLAG_C(1) '캐리

        End Sub

        Public Sub gt_CCF()

            Dim C As Integer
            'H=C, N=0, C=Not(C)
            Call PUT_Z80A_FLAG_N(0) 'NOT제로
            C = GET_Z80A_FLAG_C()
            Call PUT_Z80A_FLAG_H(C) '하프캐리
            If (C = 0) Then '캐리
                Call PUT_Z80A_FLAG_C(1)
            Else
                Call PUT_Z80A_FLAG_C(0)
            End If

        End Sub

        Public Sub gt_CPL() '비트반전

            'A=Not(A), H=1, N=1
            Call PUT_Z80A_FLAG_N(1) '뺄셈
            Call PUT_Z80A_FLAG_H(1) '하프캐리
            Z80A_REG_A = giGetIntToInt(Not Z80A_REG_A)

        End Sub

        Public Sub gt_NEG() '음수값 : -n, (NOT n) + 1 -> 뺄셈을 음수의 덧셈으로 할 경우

            Dim iRegOrg As Integer, iResult As Integer
            'P=Before A=80h, C=Before A<>00h, A=0-A, S=Sigh(A), Z=Zero(A), H=Hcr(A), N=1
            Call PUT_Z80A_FLAG_N(1) '뺄셈
            iRegOrg = Z80A_REG_A
            iResult = (0 - iRegOrg)
            Z80A_REG_A = giGetIntToInt(iResult)
            Call PUT_Z80A_FLAG_C(IIf(iRegOrg <> 0, 1, 0)) '캐리
            Call PUT_Z80A_FLAG_H(IIf(((iRegOrg Xor iResult) And H_Flag) <> 0, 1, 0)) '하프캐리
            Call PUT_Z80A_FLAG_PV(IIf(iRegOrg = &H80, 1, 0)) '오버플로
            Call PUT_Z80A_FLAG_S(giGet8Sign(Z80A_REG_A)) 'Sign
            Call PUT_Z80A_FLAG_Z(giGet8Zero(Z80A_REG_A)) 'Zero

        End Sub

        Public Sub gt_DAA()

            Dim iRegA As Integer, iAdj As Integer, iResult As Integer, iResCry As Integer, iH As Integer, iL As Integer, F_H As Integer
            'DAA
            'S=Sign(결과), Z=Zero(결과), H=하프캐리(결과), P=Peven(결과), C=작업에따라변경
            'Debug.Print " N:" + CStr(Z80A_FLAG_N) + " A:" + Right("00" + Hex(Z80A_REG_A), 2) + " C:" + CStr(Z80A_FLAG_C) + " H:" + CStr(Z80A_FLAG_H)
            iRegA = Z80A_REG_A
            iAdj = 0
            iResult = 0
            iResCry = 0
            iH = (iRegA >> 4)
            iL = (iRegA And &HF)
            F_H = GET_Z80A_FLAG_H()
            If (GET_Z80A_FLAG_N() = 0) Then 'ADD
                If (GET_Z80A_FLAG_C() = 0) Then
                    If ((iH <= &H9) And (F_H = 0) And (iL <= &H9)) Then iAdj = &H0
                    If ((iH <= &H8) And (F_H = 0) And (iL >= &HA)) Then iAdj = &H6
                    If ((iH <= &H9) And (F_H = 1) And (iL <= &H3)) Then iAdj = &H6
                    If ((iH >= &HA) And (F_H = 0) And (iL <= &H9)) Then iAdj = &H60 : iResCry = 1
                    If ((iH >= &H9) And (F_H = 0) And (iL >= &HA)) Then iAdj = &H66 : iResCry = 1
                    If ((iH >= &HA) And (F_H = 1) And (iL <= &H3)) Then iAdj = &H66 : iResCry = 1
                Else
                    If ((iH <= &H2) And (F_H = 0) And (iL <= &H9)) Then iAdj = &H60 : iResCry = 1
                    If ((iH <= &H2) And (F_H = 0) And (iL >= &HA)) Then iAdj = &H66 : iResCry = 1
                    If ((iH <= &H3) And (F_H = 1) And (iL <= &H3)) Then iAdj = &H66 : iResCry = 1
                End If
            Else 'SUB
                If (GET_Z80A_FLAG_C() = 0) Then
                    If ((iH <= &H9) And (F_H = 0) And (iL <= &H9)) Then iAdj = &H0
                    If ((iH <= &H8) And (F_H = 1) And (iL >= &H6)) Then iAdj = &HFA
                Else
                    If ((iH >= &H7) And (F_H = 0) And (iL <= &H9)) Then iAdj = &HA0 : iResCry = 1
                    If ((iH >= &H6) And (F_H = 1) And (iL >= &H6)) Then iAdj = &H9A : iResCry = 1
                End If
            End If
            iResult = (iRegA + iAdj)
            Z80A_REG_A = giGetIntToInt(iResult)
            Call PUT_Z80A_FLAG_H(IIf(((iRegA And &HF) + (iAdj And &HF)) > &HF, 1, 0)) '하프캐리
            Call PUT_Z80A_FLAG_C(iResCry) '캐리
            Call PUT_Z80A_FLAG_PV(TBL.Gi_P_Table(Z80A_REG_A)) '1:짝수,0:홀수
            Call PUT_Z80A_FLAG_S((giGet8Sign(Z80A_REG_A))) 'Sign
            Call PUT_Z80A_FLAG_Z((giGet8Zero(Z80A_REG_A))) 'Zero

        End Sub

        Public Sub gt_PUSH_16(ByVal oVal As Integer)

            Call MEM.PUT_MSX_MEMORY(goGetLngToLng(Z80A_REG_SP - 1), giGetLngToIntH(oVal))
            Call MEM.PUT_MSX_MEMORY(goGetLngToLng(Z80A_REG_SP - 2), giGetLngToIntL(oVal))
            Z80A_REG_SP = goGetLngToLng(Z80A_REG_SP - 2)

        End Sub

        Public Sub gt_POP_16(ByRef Reg16 As Integer)

            Reg16 = goGetIntHLToLng(MEM.GET_MSX_MEMORY(((Z80A_REG_SP + 1) And &HFFFF)), MEM.GET_MSX_MEMORY(Z80A_REG_SP))
            Z80A_REG_SP = ((Z80A_REG_SP + 2) And &HFFFF)

        End Sub

        Public Sub gt_POP_16TO2(ByRef RegH As Integer, ByRef RegL As Integer)

            RegH = MEM.GET_MSX_MEMORY(((Z80A_REG_SP + 1) And &HFFFF))
            RegL = MEM.GET_MSX_MEMORY(Z80A_REG_SP)
            Z80A_REG_SP = ((Z80A_REG_SP + 2) And &HFFFF)

        End Sub

        Public Sub gt_RLCA()

            Call gt_RLC(Z80A_REG_A, 1)

        End Sub

        Public Sub gt_RLA()

            Call gt_RL(Z80A_REG_A, 1)

        End Sub

        Public Sub gt_RRCA()

            Call gt_RRC(Z80A_REG_A, 1)

        End Sub

        Public Sub gt_RRA()

            Call gt_RR(Z80A_REG_A, 1)

        End Sub

        Public Sub gt_RLC(ByRef Reg8 As Integer, ByVal iArg As Integer)

            Dim C As Integer
            'H=0, N=0, C=1[1]
            'P=Peven, S=Sign, Z=Zero
            Call PUT_Z80A_FLAG_N(0) 'Not뺄셈
            C = IIf((Reg8 And 128) = 0, 0, 1) '1[1]
            Reg8 = (((Reg8 << 1) And 255) + C) '2[7]+C
            Call PUT_Z80A_FLAG_C(C)
            Call PUT_Z80A_FLAG_H(0) 'Not하프캐리
            If (iArg = 0) Then
                Call PUT_Z80A_FLAG_PV(TBL.Gi_P_Table(Reg8)) '1:짝수,0:홀수
                Call PUT_Z80A_FLAG_S(giGet8Sign(Reg8)) 'Sign
                Call PUT_Z80A_FLAG_Z(giGet8Zero(Reg8)) 'Zero
            End If

        End Sub

        Public Sub gt_RL(ByRef Reg8 As Integer, ByVal iArg As Integer)

            Dim C As Integer
            'H=0, N=0, C=1[1]
            'P=Peven, S=Sign, Z=Zero
            Call PUT_Z80A_FLAG_N(0) 'Not뺄셈
            C = IIf((Reg8 And 128) = 0, 0, 1) '1[1]
            Reg8 = (((Reg8 << 1) And 255) + GET_Z80A_FLAG_C()) '2[7]+FC
            Call PUT_Z80A_FLAG_C(C)
            Call PUT_Z80A_FLAG_H(0) 'Not하프캐리
            If (iArg = 0) Then
                Call PUT_Z80A_FLAG_PV(TBL.Gi_P_Table(Reg8)) '1:짝수,0:홀수
                Call PUT_Z80A_FLAG_S(giGet8Sign(Reg8)) 'Sign
                Call PUT_Z80A_FLAG_Z(giGet8Zero(Reg8)) 'Zero
            End If

        End Sub

        Public Sub gt_RRC(ByRef Reg8 As Integer, ByVal iArg As Integer)

            Dim C As Integer
            'H=0, N=0, C=8[1]
            'P=Peven, S=Sign, Z=Zero
            Call PUT_Z80A_FLAG_N(0) 'Not뺄셈
            C = (Reg8 And 1) '8[1]
            Reg8 = ((C << 7) + (Reg8 >> 1)) 'C+1[7]
            Call PUT_Z80A_FLAG_C(C)
            Call PUT_Z80A_FLAG_H(0) 'Not하프캐리
            If (iArg = 0) Then
                Call PUT_Z80A_FLAG_PV(TBL.Gi_P_Table(Reg8)) '1:짝수,0:홀수
                Call PUT_Z80A_FLAG_S(giGet8Sign(Reg8)) 'Sign
                Call PUT_Z80A_FLAG_Z(giGet8Zero(Reg8)) 'Zero
            End If

        End Sub

        Public Sub gt_RR(ByRef Reg8 As Integer, ByVal iArg As Integer)

            Dim C As Integer
            'H=0, N=0, C=8[1]
            'P=Peven, S=Sign, Z=Zero
            Call PUT_Z80A_FLAG_N(0) 'Not뺄셈
            C = (Reg8 And 1) '8[1]
            Reg8 = ((GET_Z80A_FLAG_C() << 7) + (Reg8 >> 1)) 'FC+1[7]
            Call PUT_Z80A_FLAG_C(C)
            Call PUT_Z80A_FLAG_H(0) 'Not하프캐리
            If (iArg = 0) Then
                Call PUT_Z80A_FLAG_PV(TBL.Gi_P_Table(Reg8)) '1:짝수,0:홀수
                Call PUT_Z80A_FLAG_S(giGet8Sign(Reg8)) 'Sign
                Call PUT_Z80A_FLAG_Z(giGet8Zero(Reg8)) 'Zero
            End If

        End Sub

        Public Sub gt_SLA(ByRef Reg8 As Integer)

            Dim C As Integer
            'S=Sign, Z=Zero, H=0, P=Peven, N=0, C=1[1]
            Call PUT_Z80A_FLAG_N(0) 'Not뺄셈
            C = IIf((Reg8 And 128) = 0, 0, 1) '1[1]
            Reg8 = (((Reg8 << 1) And 255)) '2[7]+0
            Call PUT_Z80A_FLAG_C(C)
            Call PUT_Z80A_FLAG_H(0) 'Not하프캐리
            Call PUT_Z80A_FLAG_PV(TBL.Gi_P_Table(Reg8)) '1:짝수,0:홀수
            Call PUT_Z80A_FLAG_S(giGet8Sign(Reg8)) 'Sign
            Call PUT_Z80A_FLAG_Z(giGet8Zero(Reg8)) 'Zero

        End Sub

        Public Sub gt_SLL(ByRef Reg8 As Integer)

            Dim C As Integer
            Call PUT_Z80A_FLAG_N(0) 'Not뺄셈
            C = IIf((Reg8 And 128) = 0, 0, 1) '1[1]
            Reg8 = (((Reg8 << 1) And 255) + 1) '2[7]+1 '+1버그명령???
            Call PUT_Z80A_FLAG_C(C)
            Call PUT_Z80A_FLAG_H(0) 'Not하프캐리
            Call PUT_Z80A_FLAG_PV(TBL.Gi_P_Table(Reg8)) '1:짝수,0:홀수
            Call PUT_Z80A_FLAG_S(giGet8Sign(Reg8)) 'Sign
            Call PUT_Z80A_FLAG_Z(giGet8Zero(Reg8)) 'Zero

        End Sub

        Public Sub gt_SRL(ByRef Reg8 As Integer)

            Dim C As Integer
            'S=0, Z=Zero, H=0, P=Peven, N=0, C=8[1]
            Call PUT_Z80A_FLAG_N(0) 'Not뺄셈
            C = (Reg8 And 1) '8[1]
            Reg8 = (Reg8 >> 1) '0+1[7]
            Call PUT_Z80A_FLAG_C(C)
            Call PUT_Z80A_FLAG_H(0) 'Not하프캐리
            Call PUT_Z80A_FLAG_PV(TBL.Gi_P_Table(Reg8)) '1:짝수,0:홀수
            Call PUT_Z80A_FLAG_S(0) 'giGet8Sign(Reg8) 'Sign
            Call PUT_Z80A_FLAG_Z(giGet8Zero(Reg8)) 'Zero

        End Sub

        Public Sub gt_SRA(ByRef Reg8 As Integer)

            Dim C As Integer, C1 As Integer
            'S=Sign, Z=Zero, H=0, P=Peven, N=0, C=8[1]
            Call PUT_Z80A_FLAG_N(0) 'Not뺄셈
            C = (Reg8 And 1) '8[1]
            C1 = IIf((Reg8 And 128) = 0, 0, 1) '1[1]
            Reg8 = ((C1 << 7) + (Reg8 >> 1)) '1[1]+1[7]
            Call PUT_Z80A_FLAG_C(C)
            Call PUT_Z80A_FLAG_H(0) 'Not하프캐리
            Call PUT_Z80A_FLAG_PV(TBL.Gi_P_Table(Reg8)) '1:짝수,0:홀수
            Call PUT_Z80A_FLAG_S(giGet8Sign(Reg8)) 'Sign
            Call PUT_Z80A_FLAG_Z(giGet8Zero(Reg8)) 'Zero

        End Sub

        Public Sub gt_RLD()

            Dim Reg8 As Integer, iVal As Integer, iValx As Integer, iValA1 As Integer, iValA2 As Integer, iValB1 As Integer, iValB2 As Integer
            'A,(HL)
            'S=Sign, Z=Zero, H=0, P=Peven, N=0
            Call PUT_Z80A_FLAG_N(0) 'Not뺄셈
            iValA1 = ((Z80A_REG_A >> 4))
            iValA2 = (Z80A_REG_A And 15)
            iVal = MEM.GET_MSX_MEMORY(GET_Z80A_REG_HL())
            iValB1 = (iVal >> 4)
            iValB2 = (iVal And 15)
            iValx = iValA2
            iValA2 = iValB1
            iValB1 = iValB2
            iValB2 = iValx
            Reg8 = ((iValA1 << 4) + iValA2)
            Z80A_REG_A = Reg8
            Call MEM.PUT_MSX_MEMORY(GET_Z80A_REG_HL(), ((iValB1 << 4) + iValB2))
            Call PUT_Z80A_FLAG_H(0) 'Not하프캐리
            Call PUT_Z80A_FLAG_PV(TBL.Gi_P_Table(Reg8)) '1:짝수,0:홀수
            Call PUT_Z80A_FLAG_S(giGet8Sign(Reg8)) 'Sign
            Call PUT_Z80A_FLAG_Z(giGet8Zero(Reg8)) 'Zero

        End Sub

        Public Sub gt_RRD()

            Dim Reg8 As Integer, iVal As Integer, iValx As Integer, iValA1 As Integer, iValA2 As Integer, iValB1 As Integer, iValB2 As Integer
            'A,(HL)
            'S=Sign, Z=Zero, H=0, P=Peven, N=0
            Call PUT_Z80A_FLAG_N(0) 'Not뺄셈
            iValA1 = (Z80A_REG_A >> 4)
            iValA2 = (Z80A_REG_A And 15)
            iVal = MEM.GET_MSX_MEMORY(GET_Z80A_REG_HL())
            iValB1 = (iVal >> 4)
            iValB2 = (iVal And 15)
            iValx = iValA2
            iValA2 = iValB2
            iValB2 = iValB1
            iValB1 = iValx
            Reg8 = ((iValA1 << 4) + iValA2)
            Z80A_REG_A = Reg8
            Call MEM.PUT_MSX_MEMORY(GET_Z80A_REG_HL(), ((iValB1 << 4) + iValB2))
            Call PUT_Z80A_FLAG_H(0) 'Not하프캐리
            Call PUT_Z80A_FLAG_PV(TBL.Gi_P_Table(Reg8)) '1:짝수,0:홀수
            Call PUT_Z80A_FLAG_S(giGet8Sign(Reg8)) 'Sign
            Call PUT_Z80A_FLAG_Z(giGet8Zero(Reg8)) 'Zero

        End Sub

        Public Sub gt_LDI()

            '(DE)=(HL), HL=HL+1, DE=DE+1, BC=BC-1
            'H=0, P=BC-1<>0, N=0
            Call PUT_Z80A_FLAG_N(0) 'Not뺄셈
            Call MEM.PUT_MSX_MEMORY(GET_Z80A_REG_DE(), MEM.GET_MSX_MEMORY(GET_Z80A_REG_HL()))
            Call PUT_Z80A_REG_HL(goGetLngToLng(GET_Z80A_REG_HL() + 1))
            Call PUT_Z80A_REG_DE(goGetLngToLng(GET_Z80A_REG_DE() + 1))
            Call PUT_Z80A_REG_BC(goGetLngToLng(GET_Z80A_REG_BC() - 1))
            Call PUT_Z80A_FLAG_H(0) 'Not하프캐리
            Call PUT_Z80A_FLAG_PV(IIf(GET_Z80A_REG_BC() > 0, 1, 0)) '오버플로

        End Sub

        Public Sub gt_LDIR()

            Dim HL As Integer, DE As Integer, BC As Integer
            'Repeat (DE)=(HL), HL=HL+1, DE=DE+1, BC=BC-1 While (BC<>0)
            'H=0, P=BC-1<>0, N=0
            Call PUT_Z80A_FLAG_N(0) 'Not뺄셈
            HL = GET_Z80A_REG_HL()
            DE = GET_Z80A_REG_DE()
            BC = GET_Z80A_REG_BC()
LoopProc:
            Call MEM.PUT_MSX_MEMORY(DE, MEM.GET_MSX_MEMORY(HL))
            HL = goGetLngToLng(HL + 1)
            DE = goGetLngToLng(DE + 1)
            BC = goGetLngToLng(BC - 1)
            If (BC > 0) Then
                MSX.Gi_Z80A_CLOCK = MSX.Gi_Z80A_CLOCK + 21
                GoTo LoopProc
            Else
                MSX.Gi_Z80A_CLOCK = MSX.Gi_Z80A_CLOCK + 16
            End If
            Call PUT_Z80A_REG_HL(HL)
            Call PUT_Z80A_REG_DE(DE)
            Call PUT_Z80A_REG_BC(BC)
            Call PUT_Z80A_FLAG_H(0) 'Not하프캐리
            Call PUT_Z80A_FLAG_PV(0) 'Not오버플로

        End Sub

        Public Sub gt_LDD()

            '(DE)=(HL), HL=HL-1, DE=DE-1, BC=BC-1
            'H=0, P=BC-1<>0, N=0
            Call PUT_Z80A_FLAG_N(0) 'Not뺄셈
            Call MEM.PUT_MSX_MEMORY(GET_Z80A_REG_DE(), MEM.GET_MSX_MEMORY(GET_Z80A_REG_HL()))
            Call PUT_Z80A_REG_HL(goGetLngToLng(GET_Z80A_REG_HL() - 1))
            Call PUT_Z80A_REG_DE(goGetLngToLng(GET_Z80A_REG_DE() - 1))
            Call PUT_Z80A_REG_BC(goGetLngToLng(GET_Z80A_REG_BC() - 1))
            Call PUT_Z80A_FLAG_H(0) 'Not하프캐리
            Call PUT_Z80A_FLAG_PV(IIf(GET_Z80A_REG_BC() > 0, 1, 0)) '오버플로

        End Sub

        Public Sub gt_LDDR()

            Dim HL As Integer, DE As Integer, BC As Integer
            'Repeat (DE)=(HL), HL=HL-1, DE=DE-1, BC=BC-1 While (BC<>0)
            'H=0, P=BC-1<>0, N=0
            Call PUT_Z80A_FLAG_N(0) 'Not뺄셈
            HL = GET_Z80A_REG_HL()
            DE = GET_Z80A_REG_DE()
            BC = GET_Z80A_REG_BC()
LoopProc:
            Call MEM.PUT_MSX_MEMORY(DE, MEM.GET_MSX_MEMORY(HL))
            HL = goGetLngToLng(HL - 1)
            DE = goGetLngToLng(DE - 1)
            BC = goGetLngToLng(BC - 1)
            If (BC > 0) Then
                MSX.Gi_Z80A_CLOCK = MSX.Gi_Z80A_CLOCK + 21
                GoTo LoopProc
            Else
                MSX.Gi_Z80A_CLOCK = MSX.Gi_Z80A_CLOCK + 16
            End If
            Call PUT_Z80A_REG_HL(HL)
            Call PUT_Z80A_REG_DE(DE)
            Call PUT_Z80A_REG_BC(BC)
            Call PUT_Z80A_FLAG_H(0) 'Not하프캐리
            Call PUT_Z80A_FLAG_PV(0) 'Not오버플로

        End Sub

        Public Sub gt_CPI()

            'CP=A-(HL), HL=HL+1, BC=BC-1
            'S=Sign(CP), Z=Zero(CP), H=Hcry(CP), PV=BC-1<>0, N=1
            Call PUT_Z80A_FLAG_N(1) '뺄셈
            Call gt_CP(MEM.GET_MSX_MEMORY(GET_Z80A_REG_HL()))
            Call PUT_Z80A_REG_HL(goGetLngToLng(GET_Z80A_REG_HL() + 1))
            Call PUT_Z80A_REG_BC(goGetLngToLng(GET_Z80A_REG_BC() - 1))
            'Z80A_FLAG_C = ? '캐리
            'Z80A_FLAG_H = ? '하프캐리 -> CP결과
            'Z80A_FLAG_S = ? 'Sign     -> CP결과
            'Z80A_FLAG_Z = ? 'Zero     -> CP결과
            Call PUT_Z80A_FLAG_PV(IIf(GET_Z80A_REG_BC() > 0, 1, 0)) '오버플로

        End Sub

        Public Sub gt_CPIR()

            Dim HL As Integer, BC As Integer
            'Repeat CP=A-(HL), HL=HL+1, BC=BC-1 While (BC<>0) And (Z<>1)
            'S=Sign(CP), Z=Zero(CP), H=Hcry(CP), PV=BC-1<>0, N=1
            Call PUT_Z80A_FLAG_N(1) '뺄셈
            HL = GET_Z80A_REG_HL()
            BC = GET_Z80A_REG_BC()
LoopProc:
            Call gt_CP(MEM.GET_MSX_MEMORY(HL))
            HL = goGetLngToLng(HL + 1)
            BC = goGetLngToLng(BC - 1)
            If ((BC <> 0) And (GET_Z80A_FLAG_Z() <> 1)) Then
                MSX.Gi_Z80A_CLOCK = MSX.Gi_Z80A_CLOCK + 21
                GoTo LoopProc
            Else
                MSX.Gi_Z80A_CLOCK = MSX.Gi_Z80A_CLOCK + 16
            End If
            Call PUT_Z80A_REG_HL(HL)
            Call PUT_Z80A_REG_BC(BC)
            'Z80A_FLAG_C = ? '캐리
            'Z80A_FLAG_H = ? '하프캐리 -> CP결과
            'Z80A_FLAG_S = ? 'Sign     -> CP결과
            'Z80A_FLAG_Z = ? 'Zero     -> CP결과
            Call PUT_Z80A_FLAG_PV(IIf(GET_Z80A_REG_BC() > 0, 1, 0)) '오버플로

        End Sub

        Public Sub gt_CPD()

            'CP=A-(HL), HL=HL-1, BC=BC-1
            'S=Sign(CP), Z=Zero(CP), H=Hcry(CP), PV=BC-1<>0, N=1
            Call PUT_Z80A_FLAG_N(1) '뺄셈
            Call gt_CP(MEM.GET_MSX_MEMORY(GET_Z80A_REG_HL()))
            Call PUT_Z80A_REG_HL(goGetLngToLng(GET_Z80A_REG_HL() - 1))
            Call PUT_Z80A_REG_BC(goGetLngToLng(GET_Z80A_REG_BC() - 1))
            'Z80A_FLAG_C = ? '캐리
            'Z80A_FLAG_H = ? '하프캐리 -> CP결과
            'Z80A_FLAG_S = ? 'Sign     -> CP결과
            'Z80A_FLAG_Z = ? 'Zero     -> CP결과
            Call PUT_Z80A_FLAG_PV(IIf(GET_Z80A_REG_BC() > 0, 1, 0)) '오버플로

        End Sub

        Public Sub gt_CPDR()

            Dim HL As Integer, BC As Integer
            'Repeat CP=A-(HL), HL=HL-1, BC=BC-1 While (BC<>0) And (Z<>1)
            'S=Sign(CP), Z=Zero(CP), H=Hcry(CP), PV=BC-1<>0, N=1
            Call PUT_Z80A_FLAG_N(1) '뺄셈
            HL = GET_Z80A_REG_HL()
            BC = GET_Z80A_REG_BC()
LoopProc:
            Call gt_CP(MEM.GET_MSX_MEMORY(HL))
            HL = goGetLngToLng(HL - 1)
            BC = goGetLngToLng(BC - 1)
            If ((BC <> 0) And (GET_Z80A_FLAG_Z() <> 1)) Then
                MSX.Gi_Z80A_CLOCK = MSX.Gi_Z80A_CLOCK + 21
                GoTo LoopProc
            Else
                MSX.Gi_Z80A_CLOCK = MSX.Gi_Z80A_CLOCK + 16
            End If
            Call PUT_Z80A_REG_HL(HL)
            Call PUT_Z80A_REG_BC(BC)
            'Z80A_FLAG_C = ? '캐리
            'Z80A_FLAG_H = ? '하프캐리 -> CP결과
            'Z80A_FLAG_S = ? 'Sign     -> CP결과
            'Z80A_FLAG_Z = ? 'Zero     -> CP결과
            Call PUT_Z80A_FLAG_PV(IIf(GET_Z80A_REG_BC() > 0, 1, 0)) '오버플로

        End Sub
    End Module

End Namespace
