﻿'*******************************************************************************
'*                                                                             *
'* 제    목 : MSX                                                              *
'*                                                                             *
'* 개발환경 : Ms Windows 2003, Visual Studio 2008 Sp1 [VB.NET]                 *
'* 회    사 : 명도전산(MdoSoft,MdoSystem)                                      *
'* 작 성 자 : 지익훈(智翼焄), mdo1993@hanmail.net                              *
'* 작성일자 : 2019년 06월 02일                                                 *
'* 최종수정 : 2019년 06월 06일                                                 *
'*                                                                             *
'*******************************************************************************
Public Class vnMSX2Frm

    Dim fi_TimerCpuInterval As Integer '1000=1초, 16.66=1초에60번

    '타이머(딜레이용-AutoSpeed)
    Dim fo_Exec_Time As Double
    Dim fo_ST_Timer As Double
    Dim fo_ED_Timer As Double

    Dim fi_MSX_SCREEN_MODE_Bak As Integer

    Private Sub vnMSX2Frm_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        MSX.GiMENU = 0 '0:[초기],1:시작,2:중지

        Call READ_MSX_SETTING()
        Call SETS_MSX_SETTING()

        IO.Gi_MSX_PortWrite = 0 '1:Port Write [Test용]

        FDC.Gs_DSK_A_FILE_Bak = ""
        FDC.Gs_DSK_B_FILE_Bak = ""

        FDC.Gi_MSX_DISK_A_Run = 0
        FDC.Gi_MSX_DISK_B_Run = 0

        MSX.Gi_MSX_Execute = 0 '0:중지,1:실행중
        MSX.Gi_MSX_GotFocus = 0 '0:없음,1:포커스
        Call DisplayExecuteState()
        ScreenModeLbl.Text = ""
        fi_MSX_SCREEN_MODE_Bak = -1

        Call MSX.MSX_INIT()

        'EI상테에서 IM1일경우 0038h 1초에 60번 발생
        MSX.Gi_MSX_Timer_60_INT = 0 '1초60번확인(INT)
        fi_TimerCpuInterval = IIf(MSX.Gi_MSX_Int_Timer = 0, 16, MSX.Gi_MSX_Int_Timer) '1000=1초, 16.66=1초에60번
        Timer1.Interval = fi_TimerCpuInterval
        Timer1.Enabled = True

        '사운드재생용
        Timer2.Interval = 50 '1초에20번
        Timer2.Enabled = True

        '화면표시용
        MSX.Gi_MSX_Timer_16_VDP = 0
        If (MSX.Gi_MSX_DisplayFrame = 0) Then Timer3.Interval = 16 '1초에60번
        If (MSX.Gi_MSX_DisplayFrame = 1) Then Timer3.Interval = 33 '1초에30번
        If (MSX.Gi_MSX_DisplayFrame = 2) Then Timer3.Interval = 45 '1초에22번
        If (MSX.Gi_MSX_DisplayFrame = 3) Then Timer3.Interval = 62 '1초에16번
        Timer3.Enabled = True

        PSGOUT.Gb_MidiOpened = False
        Call PSGOUT.gt_MSX_Midi_Open()

        MSX.Gi_TEST = 0 '1:Test
        MSX.TEST_0_oAddr = 0
        MSX.TEST_0_iVal = 0
        MSX.TEST_1_oAddr = 0
        MSX.TEST_1_iVal = 0
        MSX.TEST_2_oAddr = 0
        MSX.TEST_2_iVal = 0
        MSX.TEST_3_oAddr = 0
        MSX.TEST_3_iVal = 0

    End Sub

    Private Sub vnMSX2Frm_FormClosed(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosedEventArgs) Handles Me.FormClosed

        If (PSGOUT.Gb_MidiOpened = True) Then Call PSGOUT.gt_MSX_Midi_Close()

    End Sub

    Private Sub StartBtn_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles StartBtn.Click

        Dim iSz As Integer

        MSX.Gi_MSX_GotFocus = 0
        If (MSX.Gi_MSX_Execute = 1) Then
            Call DisplayExecuteState()
            GoTo ExitProc
        End If

        MSX.GiMENU = 1 '0:초기,1:[시작],2:중지

        MSX.Gi_MSX_Execute = 1
        Call DisplayExecuteState()

        fo_ST_Timer = Microsoft.VisualBasic.DateAndTime.Timer '시작시간확인 ?????.??초
        fo_Exec_Time = 0
        INT.Gi_Z80A_EI_Chk = INT.Gi_Z80A_EI_Cnt '직전명령이EI일경우(일정갯수명령실행까지인터럽트금지)

LoopProc:
        If ((INT.Go_MSX_InterruptBack = Z80A.Z80A_REG_PC) And (INT.Go_MSX_InterruptBack <> 0)) Then INT.Gi_MSX_Interrupt = 0 '인터럽트종료 [초기값(-1)불가]

        'Tape I/O
        If (MEM.Gi_MEM_PAGE0 = 0) Then 'Page#0->Slot#0
            If (Z80A.Z80A_REG_PC = &HE1) Then Call FDC.MSX_TAPE_BIOS_TAPION()
            If (Z80A.Z80A_REG_PC = &HE4) Then Call FDC.MSX_TAPE_BIOS_TAPIN()
            If (Z80A.Z80A_REG_PC = &HE7) Then Call FDC.MSX_TAPE_BIOS_TAPIOF()
            If (Z80A.Z80A_REG_PC = &HEA) Then Call FDC.MSX_TAPE_BIOS_TAPOON()
            If (Z80A.Z80A_REG_PC = &HED) Then Call FDC.MSX_TAPE_BIOS_TAPOUT()
            If (Z80A.Z80A_REG_PC = &HF0) Then Call FDC.MSX_TAPE_BIOS_TAPOOF()
            If (Z80A.Z80A_REG_PC = &HF3) Then Call FDC.MSX_TAPE_BIOS_STMOTR()
        End If

        'Disk I/O
        If (MEM.Gi_MEM_PAGE1 = 3) Then 'Page#1->Slot#3
            If (Z80A.Z80A_REG_PC = &H4010) Then Call FDC.MSX_DISK_BIOS_DSKIO() 'Read/Write sectors from disk
            If (Z80A.Z80A_REG_PC = &H4013) Then Call FDC.MSX_DISK_BIOS_DSKCHG() 'Check disk change status
            If (Z80A.Z80A_REG_PC = &H4016) Then Call FDC.MSX_DISK_BIOS_GETDPB() 'GETDPB: Disk format
            If (Z80A.Z80A_REG_PC = &H401C) Then Call FDC.MSX_DISK_BIOS_DSKFMT() 'Format disk
        End If

        Call MI.EXEC_Z80A_CODE() 'Z80A 명령 실행

        Call MSX_REG_DISPLAY()
        Application.DoEvents()
        If (MSX.Gi_MSX_Auto_Speed = 1) Then Call MSX_AUTO_SPEED()

        If (MSX.Gi_MSX_Execute = 0) Then GoTo ExitProc '계속실행 아니면 종료

        If (INT.Gi_Z80A_EI_Chk > 0) Then 'EI 바로 다음은 인터럽트 금지
            INT.Gi_Z80A_EI_Chk -= 1
            GoTo LoopProc
        End If

        'BIOS 인터럽트 금지 (Front Line)
        'If (Gi_MSX_InterruptBios = 1) Then
        '    If ((Z80A_REG_PC >= &H0) And (Z80A_REG_PC <= &H3FFF)) Then GoTo LoopProc
        'End If

        '인터럽트 - 1초에60번수행, IM1에서0038H호출, EI 다음명령 후 에 실행됨
        If ((Z80A.Z80A_REG_IFF1 = 1) And (INT.Z80A_INT_MODE = 1) And (MSX.Gi_MSX_Timer_60_INT = 1)) Then
            INT.Z80A_HALT = 1
            If ((MSX.Gi_MSX_InterruptDup = 1) Or (INT.Gi_MSX_Interrupt = 0)) Then '0:금지,1:인터럽트중복허용(컴퓨터속도느릴경우스텍오버플로워폭주됨)
                INT.Gi_MSX_Interrupt = 1 '인터럽트시작
                MSX.Gi_MSX_Timer_60_INT = 0

                iSz = 1
                INT.Go_MSX_InterruptBack = Z80A.Z80A_REG_PC
                Call Z80A.gt_PUSH_16(Z80A.Z80A_REG_PC)
                Z80A.Z80A_REG_PC = &H38 '0038h
                MSX.Gi_Z80A_CLOCK = 11
                Call Z80A.EXEC_Z80A_ADD_PC(0, iSz) '1

                If (MSX.Gi_MSX_Execute = 0) Then GoTo ExitProc '계속실행 아니면 종료

                Call MSX_REG_DISPLAY()
                Application.DoEvents()
                If (MSX.Gi_MSX_Auto_Speed = 1) Then Call MSX_AUTO_SPEED()
            End If
        End If

        GoTo LoopProc

ExitProc:

    End Sub

    Private Sub MSX_AUTO_SPEED()

        'Clock 3.57954MHz, 1 Cycle 279n * (명령State+OP코드바이트수)
        '1m(밀리)=1/1000, 1u(마이크로)=1/1000000, 1n(나노)=1/1000000000
        Dim oCpuTime As Double, oPrgTime As Double

        oCpuTime = (MSX.Gi_Z80A_ClockSize * 279) / 1000 'u=1/1,000n
        fo_Exec_Time = fo_Exec_Time + oCpuTime

        If (fo_Exec_Time < 10000) Then GoTo ExitProc '1/100초(Z80A실행시간) 지날때까지 대기

LoopProc:
        'Application.DoEvents();
        fo_ED_Timer = Microsoft.VisualBasic.DateAndTime.Timer '종료시간확인, ?????.??초
        If (fo_ED_Timer < fo_ST_Timer) Then fo_ST_Timer = fo_ED_Timer '일자변경됨
        oPrgTime = fo_ED_Timer - fo_ST_Timer
        If (oPrgTime < 0.01) Then GoTo LoopProc '1/100초(컴퓨터시간) 지날때까지대기

        fo_ST_Timer = Microsoft.VisualBasic.DateAndTime.Timer '시작시간확인
        fo_Exec_Time = 0

ExitProc:

    End Sub

    Private Sub StopBtn_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles StopBtn.Click

        MSX.Gi_MSX_GotFocus = 0
        If (MSX.Gi_MSX_Execute <> 1) Then GoTo LastProc
        MSX.Gi_MSX_Execute = 0

        MSX.GiMENU = 2 '0:초기,1:시작,2:[중지]

LastProc:
        Call DisplayExecuteState()

    End Sub

    Private Sub ClearBtn_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ClearBtn.Click

        MSX.Gi_MSX_GotFocus = 0
        If (MSX.Gi_MSX_Execute = 0) Then
            MSX.GiMENU = 0 '0:[초기],1:시작,2:중지
            Call SETS_MSX_SETTING()
            Call MSX.MSX_INIT()
        End If
        Call DisplayExecuteState()

        ScreenModeLbl.Text = ""
        fi_MSX_SCREEN_MODE_Bak = -1

    End Sub

    Private Sub SetsBtn_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SetsBtn.Click

        Dim bFocus As Integer

        bFocus = MSX.Gi_MSX_GotFocus

        MSX.Gi_MSX_GotFocus = 0
        Call DisplayExecuteState()

        SetsFrm.ShowDialog()

        MSX.Gi_MSX_GotFocus = bFocus
        Call DisplayExecuteState()

        fi_TimerCpuInterval = IIf(MSX.Gi_MSX_Int_Timer = 0, 16, MSX.Gi_MSX_Int_Timer) '1000=1초, 16.66=1초에60번
        Timer1.Interval = fi_TimerCpuInterval
        If (MSX.Gi_MSX_DisplayFrame = 0) Then Timer3.Interval = 16 '1초에60번
        If (MSX.Gi_MSX_DisplayFrame = 1) Then Timer3.Interval = 33 '1초에30번
        If (MSX.Gi_MSX_DisplayFrame = 2) Then Timer3.Interval = 45 '1초에22번
        If (MSX.Gi_MSX_DisplayFrame = 3) Then Timer3.Interval = 62 '1초에16번

    End Sub

    Private Sub DiskABtn_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles DiskABtn.Click

        MSX.Gi_MSX_GotFocus = 0
        Call DisplayExecuteState()
        If (MSX.GiMENU <> 2) Then GoTo LastProc '0:초기,1:시작,2:[중지]

        ScrnMSX.Focus()
        Cursor = Cursors.WaitCursor
        DiskABtn.Enabled = False

        Call MSL.MsxSaveStatus()

        DiskABtn.Enabled = True
        Cursor = Cursors.Default

LastProc:

    End Sub

    Private Sub DiskBBtn_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles DiskBBtn.Click

        Dim MsxFile As String

        MSX.Gi_MSX_GotFocus = 0
        Call DisplayExecuteState()
        If (MSX.GiMENU <> 0) Then GoTo LastProc '0:[초기],1:시작,2:중지

        MsxFile = MSX.gsGetMsxFileName(FN.gsTrim(ShowFileOpenDialog()))
        If (MsxFile = "") Then GoTo LastProc

        ScrnMSX.Focus()
        Cursor = Cursors.WaitCursor
        DiskBBtn.Enabled = False

        Call MSL.MsxLoadStatus(MsxFile)

        DiskBBtn.Enabled = True
        Cursor = Cursors.Default

        ScreenModeLbl.Text = ""
        fi_MSX_SCREEN_MODE_Bak = -1

LastProc:

    End Sub

    Private Sub ExitBtn_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ExitBtn.Click

        MSX.Gi_MSX_GotFocus = 0
        Call DisplayExecuteState()

        MSX.Gi_MSX_Execute = 0 '중지

        End

    End Sub

    Private Sub ScrnMSX_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ScrnMSX.Click

        MSX.Gi_MSX_GotFocus = 1
        Call DisplayExecuteState()
        ScrnMSX.Focus()

    End Sub

    Private Sub DisplayExecuteState()

        If (MSX.Gi_MSX_Execute = 0) Then
            MsxExecLbl.Text = ""
        Else
            MsxExecLbl.Text = "실행중"
        End If
        If (MSX.Gi_MSX_GotFocus = 0) Then
            MsxExecLbl.ForeColor = System.Drawing.Color.Black
        Else
            MsxExecLbl.ForeColor = System.Drawing.Color.Red
        End If

    End Sub

    Private Sub Timer1_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Timer1.Tick

        'CPU Interrupt
        MSX.Gi_MSX_Timer_60_INT = 1

    End Sub

    Private Sub Timer2_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Timer2.Tick

        '사운드재생용
        If (MSX.Gi_MSX_Execute = 1) Then '실행중
            Call PSGOUT.MSX_PSG_TONE_OUT_A(PSG.Gi_MSX_PSG_T_ON_A)
            Call PSGOUT.MSX_PSG_TONE_OUT_B(PSG.Gi_MSX_PSG_T_ON_B)
            Call PSGOUT.MSX_PSG_TONE_OUT_C(PSG.Gi_MSX_PSG_T_ON_C)
            Call PSGOUT.MSX_PSG_NOISE_OUT_A(PSG.Gi_MSX_PSG_N_ON_A)
            Call PSGOUT.MSX_PSG_NOISE_OUT_B(PSG.Gi_MSX_PSG_N_ON_B)
            Call PSGOUT.MSX_PSG_NOISE_OUT_C(PSG.Gi_MSX_PSG_N_ON_C)
        Else '중지
            Call PSGOUT.MSX_PSG_TONE_OUT_A(1)
            Call PSGOUT.MSX_PSG_TONE_OUT_B(1)
            Call PSGOUT.MSX_PSG_TONE_OUT_C(1)
            Call PSGOUT.MSX_PSG_NOISE_OUT_A(1)
            Call PSGOUT.MSX_PSG_NOISE_OUT_B(1)
            Call PSGOUT.MSX_PSG_NOISE_OUT_C(1)
        End If

        'Disk 구동 표시용
        If (FDC.Gi_MSX_DISK_A_Run > 0) Then
            DiskABtn.BackColor = Color.FromArgb(192, 255, 255)
            FDC.Gi_MSX_DISK_A_Run -= 1
            If (FDC.Gi_MSX_DISK_A_Run = 0) Then DiskABtn.BackColor = Color.FromArgb(224, 224, 224)
        End If
        If (FDC.Gi_MSX_DISK_B_Run > 0) Then
            DiskBBtn.BackColor = Color.FromArgb(192, 255, 255)
            FDC.Gi_MSX_DISK_B_Run -= 1
            If (FDC.Gi_MSX_DISK_B_Run = 0) Then DiskBBtn.BackColor = Color.FromArgb(224, 224, 224)
        End If

    End Sub

    Private Sub Timer3_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Timer3.Tick

        '화면표시용
        MSX.Gi_MSX_Timer_16_VDP = 1
        If ((MSX.Gi_MSX_Execute = 1) And (VDT.Gi_MSX_SCREEN_MODE <> fi_MSX_SCREEN_MODE_Bak)) Then '실행중
            ScreenModeLbl.Text = "SC " + IIf(VDT.Gi_MSX_SCREEN_MODE <> 10, FN.gsCStr(VDT.Gi_MSX_SCREEN_MODE, 0), "0+")
            fi_MSX_SCREEN_MODE_Bak = VDT.Gi_MSX_SCREEN_MODE
        End If

        Call VDTOUT.MSX_SCREEN_DISP()

    End Sub

    Private Function ShowFileOpenDialog() As String

        Dim R As String

        Dim OpenFileDialog1 As New OpenFileDialog

        R = ""

        OpenFileDialog1.Title = "열기"
        OpenFileDialog1.FileName = ""
        OpenFileDialog1.Filter = "모든 파일 (*.*)|*.*|MSX 파일|*.MSX"

        OpenFileDialog1.ShowDialog()

        R = OpenFileDialog1.FileName

        ShowFileOpenDialog = R

    End Function

    Private Sub READ_MSX_SETTING()

        MSX.Gi_MSX2_Sets = REG.giGetRegistry("MSX_Machine")
        MSX.Gi_DISK_Sets = REG.giGetRegistry("MSX_DiskRom")
        MSX.Gi_CHAR_Sets = REG.giGetRegistry("MSX_CharFont")

        MSX.Gi_MSX_Int_Timer = REG.giGetRegistry("MSX_IntTimer")
        MSX.Gi_MSX_DisplayFrame = REG.giGetRegistry("MSX_DisplayFrame")

        MSX.Gi_MSX_InterruptDup = REG.giGetRegistry("MSX_InterruptDup")
        MSX.Gi_MSX_Auto_Speed = REG.giGetRegistry("MSX_AutoSpeed")
        MSX.Gi_MSX_KeyChange = REG.giGetRegistry("MSX_KeyChange")
        MSX.Gi_MSX_JoyOn = REG.giGetRegistry("MSX_JoyOn")
        MSX.Gi_MSX_SpaceOn = REG.giGetRegistry("MSX_SpaceOn")
        MSX.Gi_MSX_VDT_ST_FF = REG.giGetRegistry("MSX_VdtStFf")

        MSX.Gs_CAS_FILE = MSX.gsGetCasFileName(REG.gsGetRegistry("MSX_CasFile"))
        MSX.Gs_ROM_FILE = MSX.gsGetRomFileName(REG.gsGetRegistry("MSX_RomFile"))
        MSX.Gi_ROM_TYPE = REG.giGetRegistry("MSX_RomType")
        MSX.Gs_DSK_A_FILE = MSX.gsGetDskFileName(REG.gsGetRegistry("MSX_DiskAFile"))
        MSX.Gs_DSK_B_FILE = MSX.gsGetDskFileName(REG.gsGetRegistry("MSX_DiskBFile"))
        MSX.Gi_DSK_A_ON = 0
        MSX.Gi_DSK_B_ON = 0

        If (MSX.Gi_MSX2_Sets < 0) Or (MSX.Gi_MSX2_Sets > 1) Then MSX.Gi_MSX2_Sets = 0
        If ((MSX.Gi_DISK_Sets < 0) Or (MSX.Gi_DISK_Sets > 1)) Then MSX.Gi_DISK_Sets = 0
        If ((MSX.Gi_CHAR_Sets < 0) Or (MSX.Gi_CHAR_Sets > 1)) Then MSX.Gi_CHAR_Sets = 0
        If ((MSX.Gi_MSX_Int_Timer < 10) Or (MSX.Gi_MSX_Int_Timer > 100)) Then MSX.Gi_MSX_Int_Timer = 0
        If ((MSX.Gi_MSX_DisplayFrame < 0) Or (MSX.Gi_MSX_DisplayFrame > 3)) Then MSX.Gi_MSX_DisplayFrame = 0
        If ((MSX.Gi_MSX_InterruptDup < 0) Or (MSX.Gi_MSX_InterruptDup > 1)) Then MSX.Gi_MSX_InterruptDup = 0
        If ((MSX.Gi_MSX_Auto_Speed < 0) Or (MSX.Gi_MSX_Auto_Speed > 1)) Then MSX.Gi_MSX_Auto_Speed = 0
        If ((MSX.Gi_MSX_KeyChange < 0) Or (MSX.Gi_MSX_KeyChange > 1)) Then MSX.Gi_MSX_KeyChange = 0
        If ((MSX.Gi_MSX_JoyOn < 0) Or (MSX.Gi_MSX_JoyOn > 1)) Then MSX.Gi_MSX_JoyOn = 0
        If ((MSX.Gi_MSX_SpaceOn < 0) Or (MSX.Gi_MSX_SpaceOn > 1)) Then MSX.Gi_MSX_SpaceOn = 0
        If ((MSX.Gi_MSX_VDT_ST_FF < 0) Or (MSX.Gi_MSX_VDT_ST_FF > 1)) Then MSX.Gi_MSX_VDT_ST_FF = 0
        If ((MSX.Gi_ROM_TYPE < 0) Or (MSX.Gi_ROM_TYPE > 5)) Then MSX.Gi_ROM_TYPE = 0
        If ((MSX.Gi_DSK_A_ON < 0) Or (MSX.Gi_DSK_A_ON > 1)) Then MSX.Gi_DSK_A_ON = 0
        If ((MSX.Gi_DSK_B_ON < 0) Or (MSX.Gi_DSK_B_ON > 1)) Then MSX.Gi_DSK_B_ON = 0

    End Sub

    Private Sub SETS_MSX_SETTING()

        MSX.GiMSX2 = MSX.Gi_MSX2_Sets
        MSX.GiDISK = MSX.Gi_DISK_Sets
        MSX.GiCHAR = MSX.Gi_CHAR_Sets

    End Sub

    Private Sub MSX_REG_DISPLAY()

        'PCLbl.Text = FN.gsHex(Z80A.Z80A_REG_PC, 4)
        'SPLbl.Text = FN.gsHex(Z80A.Z80A_REG_SP, 4)

        'AFLbl.Text = FN.gsHex(Z80A.GET_Z80A_REG_AF(), 4)
        'BCLbl.Text = FN.gsHex(Z80A.GET_Z80A_REG_BC(), 4)
        'DELbl.Text = FN.gsHex(Z80A.GET_Z80A_REG_DE(), 4)
        'HLLbl.Text = FN.gsHex(Z80A.GET_Z80A_REG_HL(), 4)

        'AF2Lbl.Text = FN.gsHex(Z80A.GET_Z80A_REG_AF2(), 4)
        'BC2Lbl.Text = FN.gsHex(Z80A.GET_Z80A_REG_BC2(), 4)
        'DE2Lbl.Text = FN.gsHex(Z80A.GET_Z80A_REG_DE2(), 4)
        'HL2Lbl.Text = FN.gsHex(Z80A.GET_Z80A_REG_HL2(), 4)

        'IXLbl.Text = FN.gsHex(Z80A.Z80A_REG_IX, 4)
        'IYLbl.Text = FN.gsHex(Z80A.Z80A_REG_IY, 4)

        'SLbl.Text = FN.gsCStr(Z80A.GET_Z80A_FLAG_S(), 0)
        'ZLbl.Text = FN.gsCStr(Z80A.GET_Z80A_FLAG_Z(), 0)
        'YLbl.Text = FN.gsCStr(Z80A.GET_Z80A_FLAG_Y(), 0)
        'HLbl.Text = FN.gsCStr(Z80A.GET_Z80A_FLAG_H(), 0)
        'XLbl.Text = FN.gsCStr(Z80A.GET_Z80A_FLAG_X(), 0)
        'PLbl.Text = FN.gsCStr(Z80A.GET_Z80A_FLAG_PV(), 0)
        'NLbl.Text = FN.gsCStr(Z80A.GET_Z80A_FLAG_N(), 0)
        'CLbl.Text = FN.gsCStr(Z80A.GET_Z80A_FLAG_C(), 0)

        'ILbl.Text = FN.gsHex(Z80A.Z80A_REG_I, 2)
        'RLbl.Text = FN.gsHex(Z80A.Z80A_REG_R, 2)
        'IMLbl.Text = FN.gsCStr(INT.Z80A_INT_MODE, 0)
        'IF1Lbl.Text = FN.gsCStr(Z80A.Z80A_REG_IFF1, 0)
        'IF2Lbl.Text = FN.gsCStr(Z80A.Z80A_REG_IFF2, 0)

    End Sub 
End Class
