/*

SjASMPlus Z80 Cross Compiler

This is modified sources of SjASM by Aprisobal - aprisobal@tut.by

Copyright (c) 2006 Sjoerd Mastijn

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the
use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim
that you wrote the original software. If you use this software in a product,
an acknowledgment in the product documentation would be appreciated but is
not required.

2. Altered source versions must be plainly marked as such, and must not be
misrepresented as being the original software.

3. This notice may not be removed or altered from any source distribution.

*/

// io_tape_ldrs.h

#define SaveTAP_ZX_Spectrum_48K_SZ 52

/*
        OUTPUT "SaveTAP_ZX_Spectrum_48K.bin"

        ORG 0x5E00
Loader:
        LD A,7*8
        LD (23693),A
        CALL 0x0D6B
        
        ; Load Screen$
        LD A,(Settings.LoadScreen)
        OR A
        JR Z,.SkipScreen
        
        LD IX,0x4000
        LD DE,6912
        LD A,255
        SCF  
        CALL 1366
          
.SkipScreen:                
        ; Load Code Block
        LD HL,(Settings.Start)
        PUSH HL
        LD IX,(Settings.MainBlockStart)
        LD DE,(Settings.MainBlockLength)
        LD A,255
        SCF  
        JP 1366
        
Settings:     
.LoadScreen:      DB 0 ; Is Load Screen$?
.Start:           DW 0 ; start address
.MainBlockStart:  DW 0 ;
.MainBlockLength: DW 0 ; block from 0x5E00(may be) to 0xBFFF

*/

const unsigned char SaveTAP_ZX_Spectrum_48K[]={
	0x3E,0x38,0x32,0x8D,0x5C,0xCD,0x6B,0x0D,0x3A,0x2D,
	0x5E,0xB7,0x28,0x0D,0xDD,0x21,0x00,0x40,0x11,0x00,
	0x1B,0x3E,0xFF,0x37,0xCD,0x56,0x05,0x2A,0x2E,0x5E,
	0xE5,0xDD,0x2A,0x30,0x5E,0xED,0x5B,0x32,0x5E,0x3E,
	0xFF,0x37,0xC3,0x56,0x05,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00
};

#define SaveTAP_ZX_Spectrum_128K_SZ 116

/*
        OUTPUT "SaveTAP_ZX_Spectrum_128K.bin"

        ORG 0x5E00
Loader: 
        

        LD A,7*8
        LD (23693),A
        CALL 0x0D6B
        
        ; Load Screen$
        LD A,(Settings.LoadScreen)
        OR A
        JR Z,.SkipScreen
        
        LD IX,$4000
        LD DE,6912
        LD A,255
        SCF  
        CALL 1366
        
.SkipScreen:

        LD HL,Table_BlockList.Table
        LD A,(Table_BlockList.Count)
        OR A
        JR Z,.CodeBlock
        
        ; Load Pages' Code Block
.Loop:  PUSH AF,HL
        
        CALL .LoadPage
        
        POP HL,AF
        INC HL,HL,HL,HL,HL
        DEC A        
        JR NZ,.Loop
        
.CodeBlock:           
        ; Set Default RAM Page
        LD A,(Settings.Page)
        CALL .SetPage
        
        ; Load Code Block
        LD HL,(Settings.Start)
        PUSH HL
        LD IX,(Settings.MainBlockStart)
        LD DE,(Settings.MainBlockLength)
        LD A,255
        SCF  
        JP 1366        
        
.LoadPage:
        DI
        LD A,(HL)
        CALL .SetPage
        EI
        INC HL
        LD A,(HL)
        LD LX,A
        INC HL
        LD A,(HL)
        LD HX,A
        INC HL
        LD E,(HL)
        INC HL
        LD D,(HL)
        LD A,255
        SCF  
        JP 1366  

.SetPage:
        OR 16
        LD BC,#7FFD
        OUT (C),A
        RET        

Settings:     
.LoadScreen:      DB 0 ; Is Load Screen$?
.Start:           DW 0 ; start address
.MainBlockStart:  DW 0
.MainBlockLength: DW 0 ; block from 0x5E00 to 0xBFFF
.Page:            DB 0 ; set 0 page by default   

Table_BlockList:
.Count:           DB 0
.Table:          ;DB PAGENUM
                 ;DW START
                 ;DW LENGTH
*/

const unsigned char SaveTAP_ZX_Spectrum_128K[]={
	0x3E,0x38,0x32,0x8D,0x5C,0xCD,0x6B,0x0D,0x3A,0x6B,
	0x5E,0xB7,0x28,0x0D,0xDD,0x21,0x00,0x40,0x11,0x00,
	0x1B,0x3E,0xFF,0x37,0xCD,0x56,0x05,0x21,0x74,0x5E,
	0x3A,0x73,0x5E,0xB7,0x28,0x0F,0xF5,0xE5,0xCD,0x4B,
	0x5E,0xE1,0xF1,0x23,0x23,0x23,0x23,0x23,0x3D,0x20,
	0xF1,0x3A,0x72,0x5E,0xCD,0x63,0x5E,0x2A,0x6C,0x5E,
	0xE5,0xDD,0x2A,0x6E,0x5E,0xED,0x5B,0x70,0x5E,0x3E,
	0xFF,0x37,0xC3,0x56,0x05,0xF3,0x7E,0xCD,0x63,0x5E,
	0xFB,0x23,0x7E,0xDD,0x6F,0x23,0x7E,0xDD,0x67,0x23,
	0x5E,0x23,0x56,0x3E,0xFF,0x37,0xC3,0x56,0x05,0xF6,
	0x10,0x01,0xFD,0x7F,0xED,0x79,0xC9,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00
};

#define SaveTAP_ZX_Spectrum_256K_SZ 757

/*
        OUTPUT "SaveTAP_ZX_Spectrum_256K.bin"

        ORG 0x5E00
Loader:
        DI
        
        CALL MEMORY.START

        EI
        
        LD A,7*8
        LD (23693),A
        CALL 0x0D6B
        
        ; Load Screen$
        LD A,(Settings.LoadScreen)
        OR A
        JR Z,.SkipScreen
        
        LD IX,$4000
        LD DE,6912
        LD A,255
        SCF  
        CALL 1366
        
.SkipScreen:

        LD HL,Table_BlockList.Table
        LD A,(Table_BlockList.Count)
        OR A
        JR Z,.CodeBlock
        
        ; Load Pages' Code Block
.Loop:  PUSH AF,HL
        
        CALL .LoadPage
        
        POP HL,AF
        INC HL,HL,HL,HL,HL
        DEC A        
        JR NZ,.Loop
        
.CodeBlock:           
        ; Set Default RAM Page
        LD A,(Settings.Page)
        CALL MEMORY.EX_RAM        
    
        ; Load Code Block
        LD HL,(Settings.Start)
        PUSH HL
        LD IX,(Settings.MainBlockStart)
        LD DE,(Settings.MainBlockLength)
        LD A,255
        SCF  
        JP 1366        
        
.LoadPage:
        DI
        LD A,(HL)
        PUSH HL
        CALL MEMORY.EX_RAM
        POP HL
        EI
        INC HL
        LD A,(HL)
        LD LX,A
        INC HL
        LD A,(HL)
        LD HX,A
        INC HL
        LD E,(HL)
        INC HL
        LD D,(HL)
        LD A,255
        SCF  
        JP 1366  
        
    MODULE MEMORY

;Memory driver
;(C) Pawel/RS
;(C) Creator
;Ïåðåä  ðàáîòîé ñ äðàéâåðîì âûçîâèòå ïîäï-
;ðîãðàììó START, äëÿ èíèöèàëèçàöèè è îïðå-
;äåëåíèÿ ñâîáîäíîé ïàìÿòè.
 
;Ïîäêëþ÷åíèå ëîãè÷åñêîãî áàíêà, íîìåð â A,
;íóìåðàöèÿ íà÷èíàåòñÿ ñ íóëÿ.
ONPAGE  PUSH    BC
        PUSH    HL
        LD      C,A
        LD      B,0
        LD      HL,TABL_PG
        ADD     HL,BC
        LD      A,(HL)
        POP     HL
        POP     BC
EX_RAM  DI
        PUSH    HL
        PUSH    AF
        PUSH    BC
        LD      HL,TYPE
        BIT     1,(HL)
        JR      NZ,ZS256
        BIT     2,(HL)
        JR      NZ,PROFI
        BIT     3,(HL)
        JR      NZ,TURBO_2
        BIT     4,(HL)
        JR      NZ,ATM1
        BIT     0,(HL)
        JR      NZ,SPECCY
        BIT     7,(HL)
        JR      NZ,SPECCY
        JR      TDK
 
TURBO_2 PUSH    AF
        PUSH    IX
        AND     24
        CPL
        LD      BC,#FFF7
        CALL    OUTC_A
        POP     IX
        POP     AF
        JP      SPECCY
 
ATM1    LD      BC,#FDFD
        PUSH    AF
        RRCA
        RRCA
        RRCA
        AND     3
        JR      HOME
 
PROFI   LD      BC,#DFFD
        PUSH    AF
        RRCA
        RRCA
        RRCA
        AND     7
        JR      HOME
 
ZS256   PUSH    AF
        LD      B,A
        AND     %00001000
        RLCA
        LD      C,A
        LD      A,B
        AND     %00110000
        RLCA
        RLCA
        ADD     A,C
        LD      BC,#1FFD
HOME    OUT     (C),A
        NOP
        POP     AF
 
SPECCY  LD      B,A
        AND     24
        RLCA
        RLCA
        RLCA
        LD      C,A
        LD      A,B
        AND     7
        ADD     A,C
        OR      16
        LD      BC,#7FFD
        OUT     (C),A
        NOP
TDK     POP     BC
        POP     AF
        POP     HL
        RET
 
OUTC_A  LD      IX,10835
        PUSH    IX
        JP      15663
 
 
;Èíèöèàëèçàöèÿ  è òåñò ïàìÿòè, âûçûâàåòñÿ
;â íà÷àëå ðàáîòû, ïîñëå ÷åãî ïàìÿòü çàíè-
;ìàåìóþ ïðîãðàììîé íèæå, ìîæíî èñïîëüçî-
;âàòü ïî ñâîåìó óñìîòðåíèþ.
 
START   CALL    TEST
        LD      A,(8)
        CP      #2A   ;åñëè SCORPION, òî
        RET     Z     ;óäàëèòü èç ñïèñêà
        LD      C,8   ;8-é áàíê, èñïîëü-
        JP      DEBUG ;çóþùèéñÿ ìîíèòîðîì.
 
TEST    CALL    TABINIT
        XOR     A
        LD      (TYPE),A
        INC     A
        LD      (PAGE),A
        DI
        LD      A,(#08)
        CP      #C3
        JR      NZ,ITURBO
        LD      HL,TYPE
        SET     7,(HL)
ITURBO  LD      HL,(1111)
        LD      BC,#FFF7
        LD      A,%00011111
        CALL    OUTC_A
        LD      DE,(#C000+1111)
        AND     A
        SBC     HL,DE
        LD      BC,#FFF7
        LD      A,255
        CALL    OUTC_A
        JR      NZ,IDFFD
        LD      HL,TYPE
        SET     3,(HL)
        JR      I7FFD
MM_ATM  DB      #DB,#1F,#C9
IDFFD   LD      HL,#80
        LD      DE,#1000
        LD      BC,#DFFD
        OUT     (C),D
        NOP
        LD      A,(HL)
        INC     (HL)
        CP      (HL)
        LD      (HL),A
        OUT     (C),E
        NOP
        JR      Z,I1FFD
        LD      HL,TYPE
        SET     2,(HL)
        OUT     (C),D
        NOP
        LD      B,#7F
        OUT     (C),D
        NOP
        LD      B,#DF
        OUT     (C),E
        NOP
        JR      I7FFD
I1FFD   LD      DE,#1110
        LD      B,#1F
        OUT     (C),D
        NOP
        LD      A,(HL)
        INC     (HL)
        CP      (HL)
        LD      (HL),A
        OUT     (C),E
        NOP
        JR      Z,IFDFD
        XOR     A
        OUT     (C),A
        LD      HL,TYPE
        SET     1,(HL)
        JP      I7FFD
IFDFD   LD      B,C
        LD      HL,#FFFF
        OUT     (C),D
        NOP
        LD      B,#7F
        OUT     (C),D
        NOP
        LD      A,(HL)
        LD      (RBT2+1),A
        LD      (HL),D
        LD      B,C
        OUT     (C),E
        NOP
        LD      B,#7F
        OUT     (C),D
        NOP
        LD      A,(HL)
        LD      (RBT+1),A
        LD      (HL),E
        LD      B,C
        OUT     (C),D
        NOP
        LD      B,#7F
        OUT     (C),D
        NOP
        LD      A,(HL)
        CP      D
        JR      NZ,I7FFD
        LD      HL,TYPE
        SET     4,(HL)
I7FFD   LD      HL,#FFFF
        LD      B,#7F
        OUT     (C),E
        NOP
        LD      A,(HL)
        LD      (RBT0+1),A
        LD      (HL),E
        OUT     (C),D
        NOP
        LD      (HL),D
        OUT     (C),E
        NOP
        LD      A,D
        CP      (HL)
        JR      Z,SIZED
        LD      HL,TYPE
        SET     0,(HL)
SIZED   LD      HL,#FFFF
RBT0    LD      (HL),0
        LD      B,C
        OUT     (C),E
        NOP
        LD      B,#7F
        OUT     (C),D
        NOP
RBT     LD      (HL),0
        LD      B,C
        OUT     (C),D
        NOP
        LD      B,#7F
        OUT     (C),D
        NOP
RBT2    LD      (HL),0
        CALL    VIRT
        LD      A,(PAGE)
        CP      8
        JR      C,ENDING
        LD      A,(TYPE)
        CP      1
        JR      NZ,ENDING
        LD      HL,TYPE
        SET     5,(HL)
ENDING  XOR     A
        CALL    EX_RAM
        EI
        RET
 
VIRT    LD      IX,#C000
        LD      HL,VTABL+63
        LD      B,64
V_R11   LD      A,B
        DEC     A
        CALL    EX_RAM
        LD      C,(IX+0)
        LD      (HL),C
        LD      (IX+0),A
        DEC     HL
        DJNZ    V_R11
        PUSH    AF
        LD      A,LENTABL-1
        LD      (PAGE),A
        POP     AF
        LD      DE,TABL_PG
V_R20   LD      A,(DE)
        CP      #FF
        JR      Z,V_R30
        CALL    EX_RAM
        CP      (IX+0)
        JR      Z,V_R22
        PUSH    DE
        LD      HL,TABL_PG+LENTABL
        AND     A
        SBC     HL,DE
        PUSH    HL
        POP     BC
        PUSH    DE
        POP     HL
        INC     HL
        LDIR
        PUSH    HL
        LD      HL,PAGE
        DEC     (HL)
        POP     HL
        POP     DE
        DEC     DE
V_R22   INC     DE
        JR      V_R20
V_R30   LD      B,64
        LD      HL,VTABL
V_R31   LD      A,64
        SUB     B
        CALL    EX_RAM
        LD      A,(HL)
        LD      (IX+0),A
        INC     HL
        DJNZ    V_R31
        RET
 
;óäàëåíèå èç òàáëèöû áàíêà ñ íîìåðîì â
;ðåãèñòðå C, âûçûâàòü ñðàçó ïîñëå òåñòà.
 
DEBUG   PUSH    DE
        POP     HL
NO_PG1  DEC     DE
        LD      A,(DE)
        CP      #FF
        JR      Z,NO_PG2
        CP      C
        JR      NZ,NO_PG1
        SBC     HL,DE
        PUSH    HL
        POP     BC
        PUSH    DE
        POP     HL
        INC     HL
        LDIR
        PUSH    HL
        LD      HL,PAGE
        DEC     (HL)
        POP     HL
        DEC     HL
        DEC     HL
NO_PG2  EX      DE,HL
        RET
 
;Ñîçäàíèå òàáëèöû áàíêîâ, ñ èñêëþ÷åíèåì
;íå èñïîëüçóþùèõñÿ, â äàííîì âàðèàíòå
;óäàëÿþòñÿ 2-é è 5-é áàíêè.
 
TABINIT LD      HL,TABL_PG-1
        LD      (HL),255
        INC     HL
        XOR     A
TABI1   LD      (HL),A
        INC     A
        CP      2
        JR      Z,TABI1A
        CP      5
        JR      Z,TABI1A
        JR      TABI2
TABI1A  INC     A
TABI2   INC     HL
        CP      LENTABL+1
        JR      NZ,TABI1
        LD      (HL),255
        LD      HL,VTABL
        PUSH    HL
        POP     DE
        INC     DE
        LD      BC,63
        LD      (HL),0
        LDIR
        RET
 
LENTABL EQU     62 ;ìàêñèìàëüíîå êîëè÷åñ-
                   ;òâî èñïîëüçóþùèõñÿ
                   ;áàíêîâ.
 
        DB      0  ;êîä íà÷àëà òàáëèöû
TABL_PG DS      LENTABL+1
 
TYPE    DB      0  ;òèï êîìïüþòåðà
 
PAGE    DB      0  ;îáùåå ÷èñëî äîñòóïíûõ
                   ;áàíêîâ
 
VTABL   EQU     0xBB00 ;23296 ;òàáëèöà áàíêîâ, èñ-
                      ;ïîëüçóåòñÿ òîëüêî
                      ;ïðè òåñòå, 64 áàéòà
                         
    ENDMODULE   
        
Settings:     
.LoadScreen:      DB 0 ; Is Load Screen$?
.Start:           DW 0 ; start address
.MainBlockStart:  DW 0
.MainBlockLength: DW 0 ; block from 0x5E00 to 0xBFFF
.Page:            DB 0 ; set 0 page by default   

Table_BlockList:
.Count:           DB 0
.Table:          ;DB PAGENUM
                 ;DW START
                 ;DW LENGTH
*/

const unsigned char SaveTAP_ZX_Spectrum_256K[]={
	0xF3,0xCD,0xF2,0x5E,0xFB,0x3E,0x38,0x32,0x8D,0x5C,
	0xCD,0x6B,0x0D,0x3A,0xEC,0x60,0xB7,0x28,0x0D,0xDD,
	0x21,0x00,0x40,0x11,0x00,0x1B,0x3E,0xFF,0x37,0xCD,
	0x56,0x05,0x21,0xF5,0x60,0x3A,0xF4,0x60,0xB7,0x28,
	0x0F,0xF5,0xE5,0xCD,0x50,0x5E,0xE1,0xF1,0x23,0x23,
	0x23,0x23,0x23,0x3D,0x20,0xF1,0x3A,0xF3,0x60,0xCD,
	0x76,0x5E,0x2A,0xED,0x60,0xE5,0xDD,0x2A,0xEF,0x60,
	0xED,0x5B,0xF1,0x60,0x3E,0xFF,0x37,0xC3,0x56,0x05,
	0xF3,0x7E,0xE5,0xCD,0x76,0x5E,0xE1,0xFB,0x23,0x7E,
	0xDD,0x6F,0x23,0x7E,0xDD,0x67,0x23,0x5E,0x23,0x56,
	0x3E,0xFF,0x37,0xC3,0x56,0x05,0xC5,0xE5,0x4F,0x06,
	0x00,0x21,0xAB,0x60,0x09,0x7E,0xE1,0xC1,0xF3,0xE5,
	0xF5,0xC5,0x21,0xEA,0x60,0xCB,0x4E,0x20,0x3E,0xCB,
	0x56,0x20,0x2F,0xCB,0x5E,0x20,0x0E,0xCB,0x66,0x20,
	0x1C,0xCB,0x46,0x20,0x41,0xCB,0x7E,0x20,0x3D,0x18,
	0x4E,0xF5,0xDD,0xE5,0xE6,0x18,0x2F,0x01,0xF7,0xFF,
	0xCD,0xE9,0x5E,0xDD,0xE1,0xF1,0xC3,0xD2,0x5E,0x01,
	0xFD,0xFD,0xF5,0x0F,0x0F,0x0F,0xE6,0x03,0x18,0x1A,
	0x01,0xFD,0xDF,0xF5,0x0F,0x0F,0x0F,0xE6,0x07,0x18,
	0x0F,0xF5,0x47,0xE6,0x08,0x07,0x4F,0x78,0xE6,0x30,
	0x07,0x07,0x81,0x01,0xFD,0x1F,0xED,0x79,0x00,0xF1,
	0x47,0xE6,0x18,0x07,0x07,0x07,0x4F,0x78,0xE6,0x07,
	0x81,0xF6,0x10,0x01,0xFD,0x7F,0xED,0x79,0x00,0xC1,
	0xF1,0xE1,0xC9,0xDD,0x21,0x53,0x2A,0xDD,0xE5,0xC3,
	0x2F,0x3D,0xCD,0x00,0x5F,0x3A,0x08,0x00,0xFE,0x2A,
	0xC8,0x0E,0x08,0xC3,0x63,0x60,0xCD,0x81,0x60,0xAF,
	0x32,0xEA,0x60,0x3C,0x32,0xEB,0x60,0xF3,0x3A,0x08,
	0x00,0xFE,0xC3,0x20,0x05,0x21,0xEA,0x60,0xCB,0xFE,
	0x2A,0x57,0x04,0x01,0xF7,0xFF,0x3E,0x1F,0xCD,0xE9,
	0x5E,0xED,0x5B,0x57,0xC4,0xA7,0xED,0x52,0x01,0xF7,
	0xFF,0x3E,0xFF,0xCD,0xE9,0x5E,0x20,0x0A,0x21,0xEA,
	0x60,0xCB,0xDE,0x18,0x79,0xDB,0x1F,0xC9,0x21,0x80,
	0x00,0x11,0x00,0x10,0x01,0xFD,0xDF,0xED,0x51,0x00,
	0x7E,0x34,0xBE,0x77,0xED,0x59,0x00,0x28,0x14,0x21,
	0xEA,0x60,0xCB,0xD6,0xED,0x51,0x00,0x06,0x7F,0xED,
	0x51,0x00,0x06,0xDF,0xED,0x59,0x00,0x18,0x4D,0x11,
	0x10,0x11,0x06,0x1F,0xED,0x51,0x00,0x7E,0x34,0xBE,
	0x77,0xED,0x59,0x00,0x28,0x0B,0xAF,0xED,0x79,0x21,
	0xEA,0x60,0xCB,0xCE,0xC3,0xB4,0x5F,0x41,0x21,0xFF,
	0xFF,0xED,0x51,0x00,0x06,0x7F,0xED,0x51,0x00,0x7E,
	0x32,0xEB,0x5F,0x72,0x41,0xED,0x59,0x00,0x06,0x7F,
	0xED,0x51,0x00,0x7E,0x32,0xE0,0x5F,0x73,0x41,0xED,
	0x51,0x00,0x06,0x7F,0xED,0x51,0x00,0x7E,0xBA,0x20,
	0x05,0x21,0xEA,0x60,0xCB,0xE6,0x21,0xFF,0xFF,0x06,
	0x7F,0xED,0x59,0x00,0x7E,0x32,0xD5,0x5F,0x73,0xED,
	0x51,0x00,0x72,0xED,0x59,0x00,0x7A,0xBE,0x28,0x05,
	0x21,0xEA,0x60,0xCB,0xC6,0x21,0xFF,0xFF,0x36,0x00,
	0x41,0xED,0x59,0x00,0x06,0x7F,0xED,0x51,0x00,0x36,
	0x00,0x41,0xED,0x51,0x00,0x06,0x7F,0xED,0x51,0x00,
	0x36,0x00,0xCD,0x08,0x60,0x3A,0xEB,0x60,0xFE,0x08,
	0x38,0x0C,0x3A,0xEA,0x60,0xFE,0x01,0x20,0x05,0x21,
	0xEA,0x60,0xCB,0xEE,0xAF,0xCD,0x76,0x5E,0xFB,0xC9,
	0xDD,0x21,0x00,0xC0,0x21,0x3F,0xBB,0x06,0x40,0x78,
	0x3D,0xCD,0x76,0x5E,0xDD,0x4E,0x00,0x71,0xDD,0x77,
	0x00,0x2B,0x10,0xF1,0xF5,0x3E,0x3D,0x32,0xEB,0x60,
	0xF1,0x11,0xAB,0x60,0x1A,0xFE,0xFF,0x28,0x21,0xCD,
	0x76,0x5E,0xDD,0xBE,0x00,0x28,0x16,0xD5,0x21,0xE9,
	0x60,0xA7,0xED,0x52,0xE5,0xC1,0xD5,0xE1,0x23,0xED,
	0xB0,0xE5,0x21,0xEB,0x60,0x35,0xE1,0xD1,0x1B,0x13,
	0x18,0xDA,0x06,0x40,0x21,0x00,0xBB,0x3E,0x40,0x90,
	0xCD,0x76,0x5E,0x7E,0xDD,0x77,0x00,0x23,0x10,0xF3,
	0xC9,0xD5,0xE1,0x1B,0x1A,0xFE,0xFF,0x28,0x14,0xB9,
	0x20,0xF7,0xED,0x52,0xE5,0xC1,0xD5,0xE1,0x23,0xED,
	0xB0,0xE5,0x21,0xEB,0x60,0x35,0xE1,0x2B,0x2B,0xEB,
	0xC9,0x21,0xAA,0x60,0x36,0xFF,0x23,0xAF,0x77,0x3C,
	0xFE,0x02,0x28,0x06,0xFE,0x05,0x28,0x02,0x18,0x01,
	0x3C,0x23,0xFE,0x3F,0x20,0xEE,0x36,0xFF,0x21,0x00,
	0xBB,0xE5,0xD1,0x13,0x01,0x3F,0x00,0x36,0x00,0xED,
	0xB0,0xC9,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00
};

//eof io_tape_ldrs.h
