﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Net;
using System.Windows.Forms;

namespace FileHunterSearch
{
    public partial class FrmMain : Form
    {
        private string LocalPath = Path.GetDirectoryName(System.Reflection.Assembly.GetEntryAssembly().Location) + @"\";
        private string downloadPath = Path.GetDirectoryName(System.Reflection.Assembly.GetEntryAssembly().Location) + @"\";
        private List<FileInfo> TheData;

        public FrmMain()
        {
            InitializeComponent();
            InitializeForm();
        }

        private void InitializeForm()
        {
            string[] vers = System.Reflection.Assembly.GetEntryAssembly().GetName().Version.ToString().Split('.');
            string AppVersion = $"{vers[0]}.{vers[1]}";
            lblversion.Text = $"(c) 2021 by The Kid, version {AppVersion}";
            string systname = Environment.MachineName.ToLower();
            if (systname.Equals("deltahq")) downloadPath = @"d:\downloads\";
        }

        private void button_Click(object sender, EventArgs e)
        {
            Button btn = sender as Button;
            if (btn == null) return;
            switch (btn.Name)
            {
                case "btnClose":
                    Close();
                    break;
                case "btnDownload":
                    DownloadTxt();
                    break;
                case "btnReadData":
                    ReadData();
                    break;
                case "btnSearch":
                    ZoekGame();
                    break;
                case "btnErase":
                    txtSearch.Text = "";
                    break;
                case "btnGetFile":
                    GetSelection();
                    break;
            }
        }

        private bool DownloadTxt()
        {
            Cursor.Current = Cursors.WaitCursor;
            try
            {
                ServicePointManager.Expect100Continue = true;
                ServicePointManager.SecurityProtocol = SecurityProtocolType.Tls12;
                ServicePointManager.ServerCertificateValidationCallback = delegate { return true; };
                using (WebClient client = new WebClient())
                {
                    client.DownloadFile("https://download.file-hunter.com/sha1sums.txt", LocalPath + "sha1sums.txt");
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show($"Kon het bestand niet downloaden vanwege: {ex.Message}");
                Cursor.Current = Cursors.Default;
                return false;
            }
            Cursor.Current = Cursors.Default;
            return true;
        }

        private void ReadData()
        {
            bool res = true;
            if (!File.Exists(LocalPath + "sha1sums.txt")) res = DownloadTxt();
            if (!res) return;
            TheData = new List<FileInfo>();
            Cursor.Current = Cursors.WaitCursor;
            try
            {
                List<string> cmblijst = new List<string>();
                cmblijst.Add("All");
                using (StreamReader sr = new StreamReader(LocalPath + "sha1sums.txt"))
                {
                    string line;
                    while ((line = sr.ReadLine()) != null)
                    {
                        try
                        {
                            FileInfo fi = new FileInfo();
                            string[] lines = line.Split('.');
                            if (lines.Count() < 1) continue;
                            string lin = lines[1].Trim();
                            //if (lines.Count() > 2) lin += "." + lines[2].Trim();
                            for (int a = 2; a < lines.Count(); a++)
                            {
                                lin += "." + lines[a].Trim();
                            }
                            fi.FileName = lin;
                            string[] types = lines[1].Split('\\');
                            fi.Type = types[1];
                            TheData.Add(fi);
                            if (!cmblijst.Contains(fi.Type)) cmblijst.Add(fi.Type);
                        }
                        catch (Exception ex)
                        {
                            Debug.Print(ex.Message);
                        }
                    }
                }
                cmblijst = cmblijst.OrderBy(n => n.ToString()).ToList();
                cmbBoxType.Items.AddRange(cmblijst.ToArray());
                FillListbox(TheData);
                cmbBoxType.SelectedIndex = 0;
            }
            catch (Exception ex)
            {
                MessageBox.Show($"Kon het bestand niet downloaden vanwege: {ex.Message}");
            }
            Cursor.Current = Cursors.Default;
        }

        private void ZoekGame()
        {
            string srctxt = txtSearch.Text;
            string TheTypes = cmbBoxType.SelectedItem.ToString();
            List<FileInfo> res;
            if (TheTypes.Equals("All"))
            {
                res = TheData.Where(n => n.FileName.ToLower().Contains(srctxt.ToLower())).ToList();
            }
            else
            {
                res = TheData.Where(n => n.Type.Equals(TheTypes) && n.FileName.ToLower().Contains(srctxt.ToLower())).ToList();
            }
            FillListbox(res);
        }

        private void FillListbox(List<FileInfo> deData)
        {
            lstBoxFound.Items.Clear();
            lstBoxFound.BeginUpdate();
            foreach (FileInfo dat in deData)
            {
                lstBoxFound.Items.Add(dat.ToString());
            }
            lstBoxFound.EndUpdate();
        }

        private void cmbBoxType_SelectedIndexChanged(object sender, EventArgs e)
        {
            ZoekGame();
        }

        private bool GetSelection()
        {
            Cursor.Current = Cursors.WaitCursor;
            try
            {
                ServicePointManager.Expect100Continue = true;
                ServicePointManager.SecurityProtocol = SecurityProtocolType.Tls12;
                ServicePointManager.ServerCertificateValidationCallback = delegate { return true; };
                using (WebClient client = new WebClient())
                {
                    List<int> downloadedidxs = new List<int>();
                    foreach (string lbi in lstBoxFound.SelectedItems)
                    {
                        string fil = "";
                        try
                        {
                            fil = "https://download.file-hunter.com" + lbi;
                            fil = fil.Replace('\\', '/');
                            string name = Path.GetFileName(lbi);
                            name = downloadPath + name;
                            client.DownloadFile(fil, name);
                            int idx = lstBoxFound.Items.IndexOf(lbi);
                            downloadedidxs.Add(idx);
                        }
                        catch (Exception ex)
                        {
                            MessageBox.Show($"Kon het bestand {fil} niet downloaden vanwege: {ex.Message}");
                        }
                    }
                    foreach (int idx in downloadedidxs)
                    {
                        lstBoxFound.SelectedItems.Remove(lstBoxFound.Items[idx]);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show($"Kon het bestand niet downloaden vanwege: {ex.Message}");
                Cursor.Current = Cursors.Default;
                return false;
            }
            Cursor.Current = Cursors.Default;
            return true;
        }

        private void txtSearch_TextChanged(object sender, EventArgs e)
        {
            if (cmbBoxType.SelectedItem == null) return;
            ZoekGame();
        }
    }
}
