#!/usr/bin/python
# -*- coding: ascii -*-

# Import the os module, for the os.walk function
import os, sys, hashlib, sqlite3,unicodedata
from shutil import copyfile

def createDir(dirname):
	if not os.path.exists(dirname):
		print "directory '"+dirname+"' not found creating"
		os.makedirs(dirname)


createDir('sorted')
createDir('sorted/MSX1')
createDir('sorted/MSX2')
createDir('sorted/ColecoVision')
createDir('sorted/BadDump')
createDir('sorted/SystemRoms')
createDir('notfound')
createDir('unsorted')


conn = sqlite3.connect('RomDB.db')
cur = conn.cursor()
platform = ''


def getRomInfo(sha1value):

		global platform
		sql = "SELECT GameName,Year,SHA1,ifnull(shortname,'') as CompanyName,IFNULL(Remark,'') as Remark,IFNULL(Meta,'') as Meta,case when upper(Dump) = 'GOODMSX' then 'GoodMSX' when upper(Dump) = 'BAD' then 'BadDump' when upper(Dump) = 'AUTHOR' then 'original'  else '' end as Dump,case when upper(Dump) = 'BAD' then 'BadDump' when upper(Dump) = 'SYSTEM' then 'SystemRoms' else Platform end as Platform,t2.HashID as GameID  FROM msxdb_rominfo t1 join msxdb_romdetails t2 on t1.GameID=t2.GameID join msxdb_company t3 on t1.CompanyID1=t3.company_id  where trim(upper(sha1))=upper('"+sha1value+"')"
		cur.execute(sql)

		row = cur.fetchone()

		if row is None:
			return 'NotFound'

		if row[0] is None :
			GameName=''
		else: GameName=makeFSSafe(row[0])

		if row[3] is None :
			row3=''
		else:
			row3=makeFSSafe(row[3])
			#print row3

		if row[1] is None :
			row1=''
		else:row1=makeFSSafe(row[1])

		if row[4] is None :
			row4=''
		else:
			row4=formatname(row[4])
			#print "Company:"+ row4

		if row[5] is None :
			Remark=''
		else:
			Remark=formatname(row[5])
			#print "Remark:"+ Remark

		if row[6] is None :
			Meta=''
		else:
			Meta=formatname(row[6])
			#print "Meta:"+Meta

		if row[7] is None :
			platform=''
		else: platform=row[7]


		#print sql
		fname =GameName +' - '+ row3 +' ('+row1+')' +row4+Remark+Meta+' ['+str(row[8])+']'+'.rom'

		#print fname

		return fname

def makeFSSafe(strFormat):
	strFormat = strFormat.strip()

	strFormat=strFormat.replace(u"\u00f8", "o")
	strFormat=strFormat.replace(u"\u00e9", "e")
	strFormat=strFormat.replace(u"\u00e1", "a")
	strFormat=strFormat.replace(u"\u02bc", "'")
	strFormat=strFormat.replace(u"\u00f1", "'")
	strFormat=strFormat.replace(u"\u00ca", "E")

	strFormat = strFormat.replace("?", "")
	strFormat = strFormat.replace("/", "-")
	strFormat = strFormat.replace(":", "")
	strFormat = strFormat.replace("\\r", "")
	strFormat = strFormat.replace("\\n", "")
	strFormat = strFormat.replace("\\t", "")
	strFormat = strFormat.replace("[[", "[")
	strFormat = strFormat.replace("]]", "]")

	return strFormat.encode('ascii', 'ignore')

def formatname(strField):
	strField = makeFSSafe(strField)

	if len(strField.strip())==0:
		return ''

	strfield = ' ['+strField+']'

	return makeFSSafe(strfield)

def sha1value(fname):
	BLOCKSIZE = 65536 #64Kb
	hasher = hashlib.sha1()
	with open(fname, 'rb') as afile:
		buf = afile.read(BLOCKSIZE)
		while len(buf) > 0:
			hasher.update(buf)
			buf = afile.read(BLOCKSIZE)
	afile.close()
	#print 'end hash'
	return (hasher.hexdigest())


def handlefiles(dirname,fname):
	#print fname
	global platform
	#print "ok"
	fromfile = (dirName+'/'+fname)

	try:
		if fname[-3:].upper()!=".PY":
			hash=sha1value(fromfile).upper()
			newfilename = getRomInfo(hash)
			#print "ok"

			#too bad... let's move this one to the unknown map

			tofile 	 = os.path.abspath("./sorted/"+platform+"/"+newfilename)

			if newfilename=="NotFound":
				print "NotFound:"+fromfile+"\t"+hash
				copyfile(fromfile,"./notfound/"+fname)
				os.remove(fromfile)
				return
			#great! rom found


			print makeFSSafe(platform+" >> "+ tofile)
			#"+fromfile+" copy to "+
			copyfile(fromfile,tofile)
			#And delete original file
			os.remove(fromfile)
	except Exception as e: print(e)



# Set the directory you want to start from
rootDir = './unsorted'
for dirName, subdirList, fileList in os.walk(rootDir):
	#print('Found directory: %s' % )
	for fname in sorted(fileList):
		handlefiles(dirName,fname)

conn.close()
